/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.block.crop.RiceCropBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.SimpleTier;

public class SickleItem
extends SwordItem {
    private static final SimpleTier SICKLE_TIER = new SimpleTier(BlockTags.INCORRECT_FOR_STONE_TOOL, 2000, 4.0f, 1.0f, 5, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT}));

    public SickleItem() {
        super((Tier)SICKLE_TIER, new Item.Properties());
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return super.useOn(context);
        }
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = context.getClickedPos();
        int breakCount = 0;
        for (int x = -2; x <= 2; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    if (!this.harvest(pos, x, y, z, level, player)) continue;
                    ++breakCount;
                }
            }
        }
        ItemStack stack = context.getItemInHand();
        serverLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
        player.sweepAttack();
        stack.hurtAndBreak(breakCount, (LivingEntity)player, EquipmentSlot.MAINHAND);
        player.getCooldowns().addCooldown((Item)this, 10);
        return InteractionResult.SUCCESS;
    }

    private boolean harvest(BlockPos pos, int x, int y, int z, Level level, Player player) {
        BlockPos newPos = pos.offset(x, y, z);
        if (!level.mayInteract(player, newPos)) {
            return false;
        }
        BlockState blockState = level.getBlockState(newPos);
        if (blockState.isAir()) {
            return false;
        }
        Block block = blockState.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            if (block instanceof RiceCropBlock) {
                int position = (Integer)blockState.getValue((Property)RiceCropBlock.LOCATION);
                newPos = newPos.below(position);
                blockState = level.getBlockState(newPos);
            }
            if (cropBlock.isMaxAge(blockState)) {
                cropBlock.playerDestroy(level, player, newPos, blockState, null, ItemStack.EMPTY);
                BlockState stateForAge = cropBlock.getStateForAge(0);
                BooleanProperty waterlogged = BlockStateProperties.WATERLOGGED;
                if (stateForAge.hasProperty((Property)waterlogged)) {
                    stateForAge = (BlockState)stateForAge.setValue((Property)waterlogged, (Comparable)((Boolean)blockState.getValue((Property)waterlogged)));
                }
                level.setBlock(newPos, stateForAge, 3);
                level.levelEvent(null, 2001, newPos, Block.getId((BlockState)blockState));
                return true;
            }
            return false;
        }
        if (block instanceof BushBlock && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.gameMode.destroyBlock(newPos);
            level.levelEvent(null, 2001, newPos, Block.getId((BlockState)blockState));
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext context, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.sickle").withStyle(ChatFormatting.GRAY));
    }
}

