/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.loot;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModLootModifier;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class AdvanceBlockMatchTool
implements LootItemCondition {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"advance_block_match_tool");
    public static final MapCodec<AdvanceBlockMatchTool> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EquipmentSlot.CODEC.fieldOf("slot").forGetter(tool -> tool.slot), (App)ItemPredicate.CODEC.fieldOf("predicate").forGetter(tool -> tool.predicate)).apply((Applicative)instance, AdvanceBlockMatchTool::new));
    private final EquipmentSlot slot;
    private final ItemPredicate predicate;

    public AdvanceBlockMatchTool(EquipmentSlot slot, ItemPredicate predicate) {
        this.slot = slot;
        this.predicate = predicate;
    }

    public LootItemConditionType getType() {
        return ModLootModifier.ADVANCE_BLOCK_MATCH_TOOL;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.THIS_ENTITY);
    }

    public boolean test(LootContext context) {
        Entity entity;
        if (context.hasParam(LootContextParams.THIS_ENTITY) && (entity = (Entity)context.getParam(LootContextParams.THIS_ENTITY)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack stack = livingEntity.getItemBySlot(this.slot);
            return this.predicate.test(stack);
        }
        return false;
    }

    public static LootItemCondition.Builder toolMatches(EquipmentSlot slot, ItemPredicate builder) {
        return () -> new AdvanceBlockMatchTool(slot, builder);
    }
}

