/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.loot;

import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.PotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModLootModifier;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import com.github.ysbbbbbb.kaleidoscopecookery.item.RecipeItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class RecipeRandomlyFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"recipe_randomly");
    public static final MapCodec<RecipeRandomlyFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> RecipeRandomlyFunction.commonFields((RecordCodecBuilder.Instance)instance).and((App)RecipeItem.RecipeRecord.CODEC.listOf().optionalFieldOf("recipes", List.of()).forGetter(f -> f.possibleRecipes)).apply((Applicative)instance, RecipeRandomlyFunction::new));
    private final List<RecipeItem.RecipeRecord> possibleRecipes;

    protected RecipeRandomlyFunction(List<LootItemCondition> predicates, List<RecipeItem.RecipeRecord> possibleRecipes) {
        super(predicates);
        this.possibleRecipes = ImmutableList.copyOf(possibleRecipes);
    }

    public LootItemFunctionType<RecipeRandomlyFunction> getType() {
        return ModLootModifier.RECIPE_RANDOMLY;
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        RandomSource randomsource = context.getRandom();
        if (!this.possibleRecipes.isEmpty()) {
            RecipeItem.RecipeRecord record = this.possibleRecipes.get(randomsource.nextInt(this.possibleRecipes.size()));
            RecipeItem.setRecipe(stack, record);
            return stack;
        }
        List keys = FoodBiteRegistry.FOOD_DATA_MAP.keySet().stream().toList();
        if (keys.isEmpty()) {
            return stack;
        }
        ResourceLocation randomKey = (ResourceLocation)keys.get(randomsource.nextInt(keys.size()));
        Item result = FoodBiteRegistry.getItem(randomKey);
        RegistryAccess registryAccess = context.getLevel().registryAccess();
        List potRecipes = context.getLevel().getRecipeManager().getAllRecipesFor(ModRecipes.POT_RECIPE);
        for (RecipeHolder recipeHolder : potRecipes) {
            PotRecipe recipe = (PotRecipe)recipeHolder.value();
            ItemStack resultItem = recipe.getResultItem((HolderLookup.Provider)registryAccess);
            if (!resultItem.is(result)) continue;
            List<ItemStack> inputs = recipe.getIngredients().stream().filter(i -> !i.isEmpty()).map(i -> i.getItems()[0]).toList();
            RecipeItem.RecipeRecord record = new RecipeItem.RecipeRecord(inputs, resultItem, RecipeItem.POT);
            RecipeItem.setRecipe(stack, record);
            return stack;
        }
        List stockpotRecipes = context.getLevel().getRecipeManager().getAllRecipesFor(ModRecipes.STOCKPOT_RECIPE);
        for (RecipeHolder recipeHolder : stockpotRecipes) {
            StockpotRecipe recipe = (StockpotRecipe)recipeHolder.value();
            ItemStack resultItem = recipe.getResultItem((HolderLookup.Provider)registryAccess);
            if (!resultItem.is(result)) continue;
            List<ItemStack> inputs = recipe.getIngredients().stream().filter(i -> !i.isEmpty()).map(i -> i.getItems()[0]).toList();
            RecipeItem.RecipeRecord record = new RecipeItem.RecipeRecord(inputs, resultItem, RecipeItem.STOCKPOT);
            RecipeItem.setRecipe(stack, record);
            return stack;
        }
        return stack;
    }

    public static Builder randomRecipe() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final List<RecipeItem.RecipeRecord> recipes = Lists.newArrayList();

        protected Builder getThis() {
            return this;
        }

        public Builder withRecord(RecipeItem.RecipeRecord record) {
            this.recipes.add(record);
            return this;
        }

        public Builder pot(ItemLike output, ItemLike ... input) {
            List<ItemStack> list = Arrays.stream(input).map(ItemStack::new).toList();
            RecipeItem.RecipeRecord record = new RecipeItem.RecipeRecord(list, new ItemStack(output), RecipeItem.POT);
            return this.withRecord(record);
        }

        public Builder stockpot(ItemLike output, ItemLike ... input) {
            List<ItemStack> list = Arrays.stream(input).map(ItemStack::new).toList();
            RecipeItem.RecipeRecord record = new RecipeItem.RecipeRecord(list, new ItemStack(output), RecipeItem.STOCKPOT);
            return this.withRecord(record);
        }

        public LootItemFunction build() {
            return new RecipeRandomlyFunction(this.getConditions(), this.recipes);
        }
    }
}

