/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.sponge.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;

public final class FileSystemUtils {
    private FileSystemUtils() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static boolean visitResources(Class<?> target, Consumer<Path> consumer, String firstPathComponent, String ... remainingPathComponents) throws IOException {
        URI uri;
        URL knownResource = FileSystemUtils.class.getClassLoader().getResource("assets/forcepack/config.yml");
        if (knownResource == null) {
            throw new IllegalStateException("config.yml does not exist, don't know where we are");
        }
        if (knownResource.getProtocol().equals("jar")) {
            String jarPathRaw = (String)Iterables.get((Iterable)Splitter.on((char)'!').split((CharSequence)knownResource.toString()), (int)0);
            URI path = URI.create(jarPathRaw + "!/");
            FileSystem fileSystem = FileSystems.getFileSystem(path);
            Path toVisit = fileSystem.getPath(firstPathComponent, remainingPathComponents);
            if (Files.exists(toVisit, new LinkOption[0])) {
                consumer.accept(toVisit);
                return true;
            }
            return false;
        }
        ArrayList<String> componentList = new ArrayList<String>();
        componentList.add(firstPathComponent);
        componentList.addAll(Arrays.asList(remainingPathComponents));
        try {
            URL url = target.getClassLoader().getResource(String.join((CharSequence)"/", componentList));
            if (url == null) {
                return false;
            }
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        consumer.accept(Paths.get(uri));
        return true;
    }
}

