/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.dependency;

import dev.vankka.dependencydownload.dependency.StandardDependency;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SnapshotDependency
extends StandardDependency {
    private final String snapshotVersion;

    public SnapshotDependency(String groupId, String artifactId, String version, String classifier, String snapshotVersion, String hash, String hashingAlgorithm) {
        super(groupId, artifactId, version, classifier, hash, hashingAlgorithm);
        this.snapshotVersion = snapshotVersion;
    }

    @Override
    public String getSnapshotVersion() {
        return this.snapshotVersion;
    }

    @Override
    public boolean isSnapshot() {
        return true;
    }

    @Override
    @NotNull
    public String getFileName() {
        String classifier = this.getClassifier();
        return this.getArtifactId() + '-' + this.getSnapshotVersion() + (classifier != null ? '-' + classifier : "") + ".jar";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SnapshotDependency that = (SnapshotDependency)o;
        return Objects.equals(this.snapshotVersion, that.snapshotVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.snapshotVersion);
    }
}

