/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.attribute;

import forcepack.libs.pe.api.PacketEvents;
import forcepack.libs.pe.api.protocol.mapper.MappedEntity;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.resources.ResourceLocation;
import forcepack.libs.pe.api.util.MathUtil;

public interface Attribute
extends MappedEntity {
    @Override
    default public ResourceLocation getName() {
        return this.getName(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    public ResourceLocation getName(ClientVersion var1);

    default public double sanitizeValue(double value) {
        return this.sanitizeValue(value, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    default public double sanitizeValue(double value, ClientVersion version) {
        if (!Double.isNaN(value)) {
            return MathUtil.clamp(value, this.getMinValue(), this.getMaxValue());
        }
        return this.getMinValue();
    }

    public double getDefaultValue();

    public double getMinValue();

    public double getMaxValue();
}

