/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.item.banner;

import forcepack.libs.pe.api.protocol.item.banner.StaticBannerPattern;
import forcepack.libs.pe.api.protocol.mapper.CopyableEntity;
import forcepack.libs.pe.api.protocol.mapper.DeepComparableEntity;
import forcepack.libs.pe.api.protocol.mapper.MappedEntity;
import forcepack.libs.pe.api.protocol.nbt.NBT;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTString;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.resources.ResourceLocation;
import forcepack.libs.pe.api.util.mappings.TypesBuilderData;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface BannerPattern
extends MappedEntity,
CopyableEntity<BannerPattern>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public String getTranslationKey();

    public static BannerPattern readDirect(PacketWrapper<?> wrapper) {
        ResourceLocation assetId = wrapper.readIdentifier();
        String translationKey = wrapper.readString();
        return new StaticBannerPattern(assetId, translationKey);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, BannerPattern pattern) {
        wrapper.writeIdentifier(pattern.getAssetId());
        wrapper.writeString(pattern.getTranslationKey());
    }

    public static BannerPattern decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        String translationKey = compound.getStringTagValueOrThrow("translation_key");
        return new StaticBannerPattern(data, assetId, translationKey);
    }

    public static NBT encode(BannerPattern bannerPattern, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(bannerPattern.getAssetId().toString()));
        compound.setTag("translation_key", new NBTString(bannerPattern.getTranslationKey()));
        return compound;
    }
}

