/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.impl.bstats.sponge;

import com.google.inject.Inject;
import forcepack.libs.pe.impl.bstats.MetricsBase;
import forcepack.libs.pe.impl.bstats.charts.CustomChart;
import forcepack.libs.pe.impl.bstats.json.JsonObjectBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.lifecycle.ConstructPluginEvent;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.plugin.PluginContainer;

public class Metrics {
    private final PluginContainer plugin;
    private final Logger logger;
    private final Path configDir;
    private final int serviceId;
    private MetricsBase metricsBase;
    private String serverUUID;
    private boolean logErrors = false;
    private boolean logSentData;
    private boolean logResponseStatusText;

    private Metrics(PluginContainer plugin, Logger logger, Path configDir, int serviceId) {
        this.plugin = plugin;
        this.logger = logger;
        this.configDir = configDir;
        this.serviceId = serviceId;
        Sponge.eventManager().registerListeners(plugin, (Object)this);
    }

    @Listener
    public void startup(ConstructPluginEvent event) {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            this.logger.warn("Failed to load bStats config!", (Throwable)e);
            return;
        }
        this.metricsBase = new MetricsBase("sponge", this.serverUUID, this.serviceId, Sponge.metricsConfigManager().effectiveCollectionState(this.plugin).asBoolean(), this::appendPlatformData, this::appendServiceData, task -> {
            Scheduler scheduler = Sponge.asyncScheduler();
            Task.Builder taskBuilder = Task.builder();
            scheduler.submit(taskBuilder.execute(task).plugin(this.plugin).build());
        }, () -> true, (arg_0, arg_1) -> ((Logger)this.logger).warn(arg_0, arg_1), arg_0 -> ((Logger)this.logger).info(arg_0), this.logErrors, this.logSentData, this.logResponseStatusText, false);
        StringBuilder builder = new StringBuilder().append(System.lineSeparator());
        builder.append("Plugin ").append(this.plugin.metadata().name().orElse(this.plugin.metadata().id())).append(" is using bStats Metrics ");
        if (Sponge.metricsConfigManager().effectiveCollectionState(this.plugin).asBoolean()) {
            builder.append(" and is allowed to send data.");
        } else {
            builder.append(" but currently has data sending disabled.").append(System.lineSeparator());
            builder.append("To change the enabled/disabled state of any bStats use in a plugin, visit the Sponge config!");
        }
        this.logger.info(builder.toString());
    }

    private void loadConfig() throws IOException {
        CommentedConfigurationNode node;
        File configPath = this.configDir.resolve("bStats").toFile();
        configPath.mkdirs();
        File configFile = new File(configPath, "config.conf");
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().file(configFile)).build();
        String serverUuidComment = "bStats (https://bStats.org) collects some basic information for plugin authors, like how\nmany people use their plugin and their total player count. It's recommended to keep bStats\nenabled, but if you're not comfortable with this, you can disable data collection in the\nSponge configuration file. There is no performance penalty associated with having metrics\nenabled, and data sent to bStats is fully anonymous.";
        if (!configFile.exists()) {
            configFile.createNewFile();
            node = (CommentedConfigurationNode)configurationLoader.load();
            ((CommentedConfigurationNode)node.node(new Object[]{"serverUuid"})).set((Object)UUID.randomUUID().toString());
            ((CommentedConfigurationNode)node.node(new Object[]{"logFailedRequests"})).set((Object)false);
            ((CommentedConfigurationNode)node.node(new Object[]{"logSentData"})).set((Object)false);
            ((CommentedConfigurationNode)node.node(new Object[]{"logResponseStatusText"})).set((Object)false);
            ((CommentedConfigurationNode)node.node(new Object[]{"serverUuid"})).set((Object)serverUuidComment);
            ((CommentedConfigurationNode)node.node(new Object[]{"configVersion"})).set((Object)2);
            configurationLoader.save((ConfigurationNode)node);
        } else {
            node = (CommentedConfigurationNode)configurationLoader.load();
            if (!((CommentedConfigurationNode)node.node(new Object[]{"configVersion"})).virtual()) {
                ((CommentedConfigurationNode)node.node(new Object[]{"configVersion"})).set((Object)2);
                ((CommentedConfigurationNode)node.node(new Object[]{"enabled"})).comment("Enabling bStats in this file is deprecated. At least one of your plugins now uses the\nSponge config to control bStats. Leave this value as you want it to be for outdated plugins,\nbut look there for further control");
                ((CommentedConfigurationNode)node.node(new Object[]{"serverUuid"})).comment(serverUuidComment);
                configurationLoader.save((ConfigurationNode)node);
            }
        }
        this.serverUUID = ((CommentedConfigurationNode)node.node(new Object[]{"serverUuid"})).getString();
        this.logErrors = ((CommentedConfigurationNode)node.node(new Object[]{"logFailedRequests"})).getBoolean(false);
        this.logSentData = ((CommentedConfigurationNode)node.node(new Object[]{"logSentData"})).getBoolean(false);
        this.logResponseStatusText = ((CommentedConfigurationNode)node.node(new Object[]{"logResponseStatusText"})).getBoolean(false);
    }

    public void shutdown() {
        this.metricsBase.shutdown();
    }

    public void addCustomChart(CustomChart chart) {
        this.metricsBase.addCustomChart(chart);
    }

    private void appendPlatformData(JsonObjectBuilder builder) {
        builder.appendField("playerAmount", Sponge.server().onlinePlayers().size());
        builder.appendField("onlineMode", Sponge.server().isOnlineModeEnabled() ? 1 : 0);
        builder.appendField("minecraftVersion", Sponge.game().platform().minecraftVersion().name());
        builder.appendField("spongeImplementation", Sponge.platform().container(Platform.Component.IMPLEMENTATION).metadata().id());
        builder.appendField("javaVersion", System.getProperty("java.version"));
        builder.appendField("osName", System.getProperty("os.name"));
        builder.appendField("osArch", System.getProperty("os.arch"));
        builder.appendField("osVersion", System.getProperty("os.version"));
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    private void appendServiceData(JsonObjectBuilder builder) {
        builder.appendField("pluginVersion", this.plugin.metadata().version().toString());
    }

    public static class Factory {
        private final PluginContainer plugin;
        private final Logger logger;
        private final Path configDir;

        @Inject
        private Factory(PluginContainer plugin, Logger logger, @ConfigDir(sharedRoot=true) Path configDir) {
            this.plugin = plugin;
            this.logger = logger;
            this.configDir = configDir;
        }

        public Metrics make(int serviceId) {
            return new Metrics(this.plugin, this.logger, this.configDir, serviceId);
        }
    }
}

