/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.impl.sponge;

import com.google.inject.Inject;
import forcepack.libs.pe.api.PacketEvents;
import forcepack.libs.pe.api.event.PacketListenerPriority;
import forcepack.libs.pe.api.event.SimplePacketListenerAbstract;
import forcepack.libs.pe.api.event.UserConnectEvent;
import forcepack.libs.pe.api.event.UserDisconnectEvent;
import forcepack.libs.pe.api.event.UserLoginEvent;
import forcepack.libs.pe.api.event.simple.PacketPlaySendEvent;
import forcepack.libs.pe.api.protocol.item.ItemStack;
import forcepack.libs.pe.api.protocol.packettype.PacketType;
import forcepack.libs.pe.api.util.TimeStampMode;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerWindowItems;
import forcepack.libs.pe.impl.bstats.charts.SimplePie;
import forcepack.libs.pe.impl.bstats.sponge.Metrics;
import forcepack.libs.pe.impl.sponge.factory.SpongePacketEventsBuilder;
import forcepack.libs.pe.impl.sponge.util.SpongeConversionUtil;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.kyori.adventure.Adventure;
import org.spongepowered.api.Server;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.lifecycle.StartingEngineEvent;
import org.spongepowered.api.event.lifecycle.StoppingEngineEvent;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;

@Plugin(value="packetevents")
public class PacketEventsPlugin {
    private final PluginContainer pluginContainer;
    private final Metrics metrics;

    @Inject
    public PacketEventsPlugin(PluginContainer pluginContainer, Metrics.Factory metricsFactory) {
        this.pluginContainer = pluginContainer;
        this.metrics = metricsFactory.make(11327);
    }

    @Listener(order=Order.EARLY)
    public void onServerStart(StartingEngineEvent<Server> event) {
        PacketEvents.setAPI(SpongePacketEventsBuilder.build(this.pluginContainer));
        PacketEvents.getAPI().load();
        PacketEvents.getAPI().getSettings().debug(false).downsampleColors(false).checkForUpdates(true).timeStampMode(TimeStampMode.MILLIS).reEncodeByDefault(true);
        PacketEvents.getAPI().init();
        if (!this.validateAdventureVersion()) {
            PacketEvents.getAPI().getLogManager().warn("Adventure version mismatch detected! This may cause issues with PacketEvents.");
            PacketEvents.getAPI().getLogManager().warn("Ensure that you are using the version of PacketEvents intended for this version of Sponge.");
            PacketEvents.getAPI().getLogManager().warn("This version of PacketEvents was built for Sponge API: 17.0.0-SNAPSHOT");
            PacketEvents.getAPI().getLogManager().warn("It is possible that Sponge has not yet updated to the correct Adventure API version for this Minecraft version.");
            PacketEvents.getAPI().getLogManager().warn("If this is the case, please kindly ask the Sponge team to update their Adventure API to the correct version.");
        }
        this.metrics.addCustomChart(new SimplePie("packetevents_version", () -> PacketEvents.getAPI().getVersion().toStringWithoutSnapshot()));
        SimplePacketListenerAbstract listener = new SimplePacketListenerAbstract(this, PacketListenerPriority.HIGH){

            @Override
            public void onPacketPlaySend(PacketPlaySendEvent event) {
                if (event.getPacketType() == PacketType.Play.Server.WINDOW_ITEMS) {
                    WrapperPlayServerWindowItems items = new WrapperPlayServerWindowItems(event);
                    for (ItemStack item : items.getItems()) {
                        org.spongepowered.api.item.inventory.ItemStack sponge = SpongeConversionUtil.toSpongeItemStack(item);
                        System.out.println(sponge.type().key(RegistryTypes.ITEM_TYPE).formatted());
                        System.out.println(SpongeConversionUtil.fromSpongeItemStack(sponge).getType().getName().toString());
                    }
                }
            }

            @Override
            public void onUserConnect(UserConnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " connected...");
            }

            @Override
            public void onUserLogin(UserLoginEvent event) {
                PacketEvents.getAPI().getLogManager().debug("You logged in! User name: " + event.getUser().getProfile().getName());
            }

            @Override
            public void onUserDisconnect(UserDisconnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " disconnected...");
            }
        };
    }

    @Listener(order=Order.LATE)
    public void onStopping(StoppingEngineEvent<Server> event) {
        PacketEvents.getAPI().terminate();
    }

    private boolean validateAdventureVersion() {
        String bundledAdventureVersion = null;
        try {
            URL fileUrl;
            URI uri;
            File jarFile;
            CodeSource src = Adventure.class.getProtectionDomain().getCodeSource();
            if (src == null) {
                PacketEvents.getAPI().getLogManager().warn("Unable to resolve CodeSource for Adventure JAR");
                return false;
            }
            String urlStr = src.getLocation().toString();
            if (urlStr.startsWith("jar:")) {
                urlStr = urlStr.substring(4);
            }
            if (urlStr.endsWith("!/")) {
                urlStr = urlStr.substring(0, urlStr.length() - 2);
            }
            if (!(jarFile = new File(uri = (fileUrl = new URL(urlStr)).toURI())).exists()) {
                PacketEvents.getAPI().getLogManager().warn("Adventure JAR file not found: " + String.valueOf(jarFile));
                return false;
            }
            try (JarFile jar = new JarFile(jarFile);){
                Manifest mf = jar.getManifest();
                if (mf != null) {
                    bundledAdventureVersion = mf.getMainAttributes().getValue("Specification-Version");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PacketEvents.getAPI().getLogManager().info("Runtime Adventure Version: " + bundledAdventureVersion);
        if (bundledAdventureVersion == null) {
            PacketEvents.getAPI().getLogManager().warn("Failed to validate Adventure version!");
            return false;
        }
        String expectedAdventureVersion = "4.25.0";
        PacketEvents.getAPI().getLogManager().info("Expected Adventure Version: 4.25.0");
        return Objects.equals(bundledAdventureVersion, "4.25.0");
    }
}

