/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.sponge.cloud.sponge;

import forcepack.libs.sponge.cloud.exception.ArgumentParseException;
import forcepack.libs.sponge.cloud.exception.CommandExecutionException;
import forcepack.libs.sponge.cloud.exception.InvalidCommandSenderException;
import forcepack.libs.sponge.cloud.exception.InvalidSyntaxException;
import forcepack.libs.sponge.cloud.exception.NoPermissionException;
import forcepack.libs.sponge.cloud.exception.NoSuchCommandException;
import forcepack.libs.sponge.cloud.sponge.SpongeCommandContextKeys;
import forcepack.libs.sponge.cloud.sponge.SpongeCommandManager;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.ComponentMessageThrowable;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SpongeDefaultExceptionHandlers {
    private static final Component NULL = Component.text((String)"null");
    private static final Component MESSAGE_INTERNAL_ERROR = Component.text((String)"An internal error occurred while attempting to perform this command.", (TextColor)NamedTextColor.RED);
    private static final Component MESSAGE_NO_PERMS = Component.text((String)"I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.", (TextColor)NamedTextColor.RED);
    private static final Component MESSAGE_UNKNOWN_COMMAND = Component.text((String)"Unknown command. Type \"/help\" for help.");

    private SpongeDefaultExceptionHandlers() {
    }

    static <C> void register(SpongeCommandManager<C> mgr) {
        mgr.exceptionController().registerHandler(InvalidSyntaxException.class, ctx -> {
            Audience audience = ctx.context().get(SpongeCommandContextKeys.COMMAND_CAUSE).audience();
            audience.sendMessage((Component)((TextComponent.Builder)Component.text().append(new Component[]{Component.text((String)"Invalid Command Syntax. Correct command syntax is: ", (TextColor)NamedTextColor.RED), Component.text((String)("/" + ((InvalidSyntaxException)ctx.exception()).correctSyntax()), (TextColor)NamedTextColor.GRAY)})).build());
        });
        mgr.exceptionController().registerHandler(InvalidCommandSenderException.class, ctx -> {
            Audience audience = ctx.context().get(SpongeCommandContextKeys.COMMAND_CAUSE).audience();
            audience.sendMessage((Component)Component.text((String)((InvalidCommandSenderException)ctx.exception()).getMessage(), (TextColor)NamedTextColor.RED));
        });
        mgr.exceptionController().registerHandler(NoPermissionException.class, ctx -> {
            Audience audience = ctx.context().get(SpongeCommandContextKeys.COMMAND_CAUSE).audience();
            audience.sendMessage(MESSAGE_NO_PERMS);
        });
        mgr.exceptionController().registerHandler(NoSuchCommandException.class, ctx -> {
            Audience audience = ctx.context().get(SpongeCommandContextKeys.COMMAND_CAUSE).audience();
            audience.sendMessage(MESSAGE_UNKNOWN_COMMAND);
        });
        mgr.exceptionController().registerHandler(ArgumentParseException.class, ctx -> {
            Audience audience = ctx.context().get(SpongeCommandContextKeys.COMMAND_CAUSE).audience();
            audience.sendMessage((Component)((TextComponent.Builder)Component.text().append(new Component[]{Component.text((String)"Invalid Command Argument: ", (TextColor)NamedTextColor.RED), SpongeDefaultExceptionHandlers.getMessage(((ArgumentParseException)ctx.exception()).getCause()).colorIfAbsent((TextColor)NamedTextColor.GRAY)})).build());
        });
        mgr.exceptionController().registerHandler(CommandExecutionException.class, ctx -> {
            Audience audience = ctx.context().get(SpongeCommandContextKeys.COMMAND_CAUSE).audience();
            audience.sendMessage(MESSAGE_INTERNAL_ERROR);
            mgr.owningPluginContainer().logger().error("Exception executing command handler", ((CommandExecutionException)ctx.exception()).getCause());
        });
        mgr.exceptionController().registerHandler(Throwable.class, ctx -> {
            Audience audience = ctx.context().get(SpongeCommandContextKeys.COMMAND_CAUSE).audience();
            audience.sendMessage(MESSAGE_INTERNAL_ERROR);
            mgr.owningPluginContainer().logger().error("An unhandled exception was thrown during command execution", ctx.exception());
        });
    }

    private static Component getMessage(Throwable throwable) {
        @Nullable Component msg = ComponentMessageThrowable.getOrConvertMessage((Throwable)throwable);
        return msg == null ? NULL : msg;
    }
}

