/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.sponge.cloud.sponge;

import forcepack.libs.sponge.cloud.component.CommandComponent;
import forcepack.libs.sponge.cloud.parser.ArgumentParser;
import forcepack.libs.sponge.cloud.parser.MappedArgumentParser;
import forcepack.libs.sponge.cloud.parser.flag.CommandFlagParser;
import forcepack.libs.sponge.cloud.parser.standard.BooleanParser;
import forcepack.libs.sponge.cloud.parser.standard.ByteParser;
import forcepack.libs.sponge.cloud.parser.standard.DoubleParser;
import forcepack.libs.sponge.cloud.parser.standard.FloatParser;
import forcepack.libs.sponge.cloud.parser.standard.IntegerParser;
import forcepack.libs.sponge.cloud.parser.standard.LongParser;
import forcepack.libs.sponge.cloud.parser.standard.ShortParser;
import forcepack.libs.sponge.cloud.parser.standard.StringArrayParser;
import forcepack.libs.sponge.cloud.parser.standard.StringParser;
import forcepack.libs.sponge.cloud.parser.standard.UUIDParser;
import forcepack.libs.sponge.cloud.sponge.NodeSource;
import forcepack.libs.sponge.cloud.type.range.ByteRange;
import forcepack.libs.sponge.cloud.type.range.DoubleRange;
import forcepack.libs.sponge.cloud.type.range.FloatRange;
import forcepack.libs.sponge.cloud.type.range.IntRange;
import forcepack.libs.sponge.cloud.type.range.LongRange;
import forcepack.libs.sponge.cloud.type.range.ShortRange;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeType;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeTypes;
import org.spongepowered.api.registry.RegistryHolder;

public final class SpongeParserMapper<C> {
    private final Map<Class<?>, Mapping<C, ?>> mappers = new HashMap();

    SpongeParserMapper(@NonNull RegistryHolder registryHolder) {
        this.initStandardMappers(registryHolder);
    }

    CommandTreeNode.Argument<? extends CommandTreeNode.Argument<?>> mapComponent(RegistryHolder registryHolder, CommandComponent<C> commandComponent) {
        boolean customSuggestionsProvider;
        CommandTreeNode.Argument<CommandTreeNode.Argument<?>> result = this.mapParser(registryHolder, commandComponent.parser());
        boolean bl = customSuggestionsProvider = commandComponent.parser() != commandComponent.suggestionProvider();
        if (customSuggestionsProvider) {
            result.customCompletions();
        }
        return result;
    }

    CommandTreeNode.Argument<? extends CommandTreeNode.Argument<?>> mapParser(RegistryHolder registryHolder, ArgumentParser<C, ?> argumentParser) {
        CommandTreeNode.StringParser result;
        ArgumentParser<C, Object> parser = argumentParser;
        while (parser instanceof MappedArgumentParser) {
            parser = ((MappedArgumentParser)parser).baseParser();
        }
        Mapping<C, ?> mapper = this.mappers.get(parser.getClass());
        if (mapper != null) {
            CommandTreeNode.Argument<? extends CommandTreeNode.Argument<?>> apply = mapper.mapper.apply(parser);
            if (mapper.cloudSuggestions) {
                apply.customCompletions();
                return apply;
            }
            result = apply;
        } else {
            result = parser instanceof NodeSource ? ((NodeSource)((Object)parser)).node(registryHolder) : ((CommandTreeNode.StringParser)((CommandTreeNode.StringParser)((CommandTreeNodeType)CommandTreeNodeTypes.STRING.get(new RegistryHolder[]{registryHolder})).createNode()).customCompletions()).word();
        }
        return result;
    }

    private void initStandardMappers(RegistryHolder registryHolder) {
        this.registerMapping(new TypeToken<StringParser<C>>(this){}, builder -> builder.to(stringParser -> {
            StringParser.StringMode mode = stringParser.stringMode();
            if (mode == StringParser.StringMode.SINGLE) {
                return ((CommandTreeNode.StringParser)((CommandTreeNode.StringParser)((CommandTreeNodeType)CommandTreeNodeTypes.STRING.get(new RegistryHolder[]{registryHolder})).createNode()).customCompletions()).word();
            }
            if (mode == StringParser.StringMode.QUOTED) {
                return (CommandTreeNode.Argument)((CommandTreeNode.StringParser)((CommandTreeNodeType)CommandTreeNodeTypes.STRING.get(new RegistryHolder[]{registryHolder})).createNode()).customCompletions();
            }
            if (mode == StringParser.StringMode.GREEDY || mode == StringParser.StringMode.GREEDY_FLAG_YIELDING) {
                return ((CommandTreeNode.StringParser)((CommandTreeNode.StringParser)((CommandTreeNodeType)CommandTreeNodeTypes.STRING.get(new RegistryHolder[]{registryHolder})).createNode()).customCompletions()).greedy();
            }
            throw new IllegalArgumentException("Unknown string mode '" + String.valueOf((Object)mode) + "'!");
        }));
        this.registerMapping(new TypeToken<ByteParser<C>>(this){}, builder -> builder.to(byteParser -> {
            CommandTreeNode.Range node = (CommandTreeNode.Range)((CommandTreeNodeType)CommandTreeNodeTypes.INTEGER.get(new RegistryHolder[]{registryHolder})).createNode();
            node.min((Number)((ByteRange)byteParser.range()).minByte());
            node.max((Number)((ByteRange)byteParser.range()).maxByte());
            return node;
        }).cloudSuggestions(true));
        this.registerMapping(new TypeToken<ShortParser<C>>(this){}, builder -> builder.to(shortParser -> {
            CommandTreeNode.Range node = (CommandTreeNode.Range)((CommandTreeNodeType)CommandTreeNodeTypes.INTEGER.get(new RegistryHolder[]{registryHolder})).createNode();
            node.min((Number)((ShortRange)shortParser.range()).minShort());
            node.max((Number)((ShortRange)shortParser.range()).maxShort());
            return node;
        }).cloudSuggestions(true));
        this.registerMapping(new TypeToken<IntegerParser<C>>(this){}, builder -> builder.to(integerParser -> {
            CommandTreeNode.Range node = (CommandTreeNode.Range)((CommandTreeNodeType)CommandTreeNodeTypes.INTEGER.get(new RegistryHolder[]{registryHolder})).createNode();
            if (integerParser.hasMin()) {
                node.min((Number)((IntRange)integerParser.range()).minInt());
            }
            if (integerParser.hasMax()) {
                node.max((Number)((IntRange)integerParser.range()).maxInt());
            }
            return node;
        }).cloudSuggestions(true));
        this.registerMapping(new TypeToken<FloatParser<C>>(this){}, builder -> builder.to(floatParser -> {
            CommandTreeNode.Range node = (CommandTreeNode.Range)((CommandTreeNodeType)CommandTreeNodeTypes.FLOAT.get(new RegistryHolder[]{registryHolder})).createNode();
            if (floatParser.hasMin()) {
                node.min((Number)Float.valueOf(((FloatRange)floatParser.range()).minFloat()));
            }
            if (floatParser.hasMax()) {
                node.max((Number)Float.valueOf(((FloatRange)floatParser.range()).maxFloat()));
            }
            return node;
        }).cloudSuggestions(true));
        this.registerMapping(new TypeToken<DoubleParser<C>>(this){}, builder -> builder.to(doubleParser -> {
            CommandTreeNode.Range node = (CommandTreeNode.Range)((CommandTreeNodeType)CommandTreeNodeTypes.DOUBLE.get(new RegistryHolder[]{registryHolder})).createNode();
            if (doubleParser.hasMin()) {
                node.min((Number)((DoubleRange)doubleParser.range()).minDouble());
            }
            if (doubleParser.hasMax()) {
                node.max((Number)((DoubleRange)doubleParser.range()).maxDouble());
            }
            return node;
        }).cloudSuggestions(true));
        this.registerMapping(new TypeToken<LongParser<C>>(this){}, builder -> builder.to(longParser -> {
            CommandTreeNode.Range node = (CommandTreeNode.Range)((CommandTreeNodeType)CommandTreeNodeTypes.LONG.get(new RegistryHolder[]{registryHolder})).createNode();
            if (longParser.hasMin()) {
                node.min((Number)((LongRange)longParser.range()).minLong());
            }
            if (longParser.hasMax()) {
                node.max((Number)((LongRange)longParser.range()).maxLong());
            }
            return node;
        }).cloudSuggestions(true));
        this.registerMapping(new TypeToken<BooleanParser<C>>(this){}, builder -> builder.to(booleanParser -> (CommandTreeNode.Argument)((CommandTreeNodeType)CommandTreeNodeTypes.BOOL.get(new RegistryHolder[]{registryHolder})).createNode()));
        this.registerMapping(new TypeToken<CommandFlagParser<C>>(this){}, builder -> builder.to(flagArgumentParser -> ((CommandTreeNode.StringParser)((CommandTreeNode.StringParser)((CommandTreeNodeType)CommandTreeNodeTypes.STRING.get(new RegistryHolder[]{registryHolder})).createNode()).customCompletions()).greedy()));
        this.registerMapping(new TypeToken<StringArrayParser<C>>(this){}, builder -> builder.to(stringArrayParser -> ((CommandTreeNode.StringParser)((CommandTreeNode.StringParser)((CommandTreeNodeType)CommandTreeNodeTypes.STRING.get(new RegistryHolder[]{registryHolder})).createNode()).customCompletions()).greedy()));
        this.registerMapping(new TypeToken<UUIDParser<C>>(this){}, builder -> builder.to(uuidParser -> (CommandTreeNode.Argument)((CommandTreeNodeType)CommandTreeNodeTypes.UUID.get(new RegistryHolder[]{registryHolder})).createNode()));
    }

    public <A extends ArgumentParser<C, ?>> void registerMapping(@NonNull TypeToken<A> cloudType, @NonNull Consumer<MappingBuilder<C, A>> configurer) {
        MappingBuilderImpl builder = new MappingBuilderImpl();
        configurer.accept(builder);
        this.mappers.put(GenericTypeReflector.erase((Type)cloudType.getType()), builder.build());
    }

    public <T, A extends ArgumentParser<C, T>> void cloudSuggestions(@NonNull TypeToken<A> parserType, boolean cloudSuggestions) throws IllegalArgumentException {
        Mapping<C, ?> mapping = this.mappers.get(GenericTypeReflector.erase((Type)parserType.getType()));
        if (mapping == null) {
            throw new IllegalArgumentException("No mapper registered for type: " + GenericTypeReflector.erase((Type)parserType.getType()).toGenericString());
        }
        this.mappers.put(GenericTypeReflector.erase((Type)parserType.getType()), new Mapping(mapping.mapper, cloudSuggestions));
    }

    public void cloudNumberSuggestions(boolean cloudNumberSuggestions) {
        this.cloudSuggestions(new TypeToken<ByteParser<C>>(this){}, cloudNumberSuggestions);
        this.cloudSuggestions(new TypeToken<ShortParser<C>>(this){}, cloudNumberSuggestions);
        this.cloudSuggestions(new TypeToken<IntegerParser<C>>(this){}, cloudNumberSuggestions);
        this.cloudSuggestions(new TypeToken<FloatParser<C>>(this){}, cloudNumberSuggestions);
        this.cloudSuggestions(new TypeToken<DoubleParser<C>>(this){}, cloudNumberSuggestions);
        this.cloudSuggestions(new TypeToken<LongParser<C>>(this){}, cloudNumberSuggestions);
    }

    private record Mapping<C, A extends ArgumentParser<C, ?>>(Function<A, CommandTreeNode.Argument<? extends CommandTreeNode.Argument<?>>> mapper, boolean cloudSuggestions) {
    }

    private static final class MappingBuilderImpl<C, A extends ArgumentParser<C, ?>>
    implements MappingBuilder<C, A> {
        private Function<A, CommandTreeNode.Argument<? extends CommandTreeNode.Argument<?>>> mapper;
        private boolean cloudSuggestions;

        private MappingBuilderImpl() {
        }

        @Override
        public @NonNull MappingBuilder<C, A> cloudSuggestions(boolean cloudSuggestions) {
            this.cloudSuggestions = cloudSuggestions;
            return this;
        }

        @Override
        public @NonNull MappingBuilder<C, A> to(@NonNull Function<A, // Could not load outer class - annotation placement on inner may be incorrect
        CommandTreeNode.Argument<? extends // Could not load outer class - annotation placement on inner may be incorrect
        CommandTreeNode.Argument<?>>> mapper) {
            this.mapper = mapper;
            return this;
        }

        private @NonNull Mapping<C, A> build() {
            Objects.requireNonNull(this.mapper, "Must provide a mapper function!");
            return new Mapping(this.mapper, this.cloudSuggestions);
        }
    }

    public static interface MappingBuilder<C, A extends ArgumentParser<C, ?>> {
        public @NonNull MappingBuilder<C, A> cloudSuggestions(boolean var1);

        public @NonNull MappingBuilder<C, A> to(@NonNull Function<A, // Could not load outer class - annotation placement on inner may be incorrect
        CommandTreeNode.Argument<? extends // Could not load outer class - annotation placement on inner may be incorrect
        CommandTreeNode.Argument<?>>> var1);
    }
}

