/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.sponge;

import com.convallyria.forcepack.api.ForcePackAPI;
import com.convallyria.forcepack.api.ForcePackPlatform;
import com.convallyria.forcepack.api.player.ForcePackPlayer;
import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.resourcepack.ResourcePackVersion;
import com.convallyria.forcepack.api.schedule.PlatformScheduler;
import com.convallyria.forcepack.api.utils.ClientVersion;
import com.convallyria.forcepack.api.utils.GeyserUtil;
import com.convallyria.forcepack.api.utils.HashingUtil;
import com.convallyria.forcepack.api.verification.ResourcePackURLData;
import com.convallyria.forcepack.sponge.command.Commands;
import com.convallyria.forcepack.sponge.event.MultiVersionResourcePackStatusEvent;
import com.convallyria.forcepack.sponge.listener.ExemptionListener;
import com.convallyria.forcepack.sponge.listener.PacketListener;
import com.convallyria.forcepack.sponge.listener.ResourcePackListener;
import com.convallyria.forcepack.sponge.player.ForcePackSpongePlayer;
import com.convallyria.forcepack.sponge.resourcepack.SpongeResourcePack;
import com.convallyria.forcepack.sponge.schedule.SpongeScheduler;
import com.convallyria.forcepack.sponge.util.FileSystemUtils;
import com.convallyria.forcepack.sponge.util.ProtocolUtil;
import com.convallyria.forcepack.webserver.ForcePackWebServer;
import com.convallyria.forcepack.webserver.downloader.WebServerDependencyDownloader;
import com.google.inject.Inject;
import forcepack.libs.bstats.sponge.Metrics;
import forcepack.libs.pe.api.PacketEvents;
import forcepack.libs.pe.impl.sponge.factory.SpongePacketEventsBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.lifecycle.RegisterChannelEvent;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.event.lifecycle.StartingEngineEvent;
import org.spongepowered.api.network.ServerConnectionState;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;

@Plugin(value="forcepack")
public class ForcePackSponge
implements ForcePackPlatform {
    private final PluginContainer pluginContainer;
    private final Logger logger;
    private final Path configDir;
    private final SpongeScheduler scheduler;
    public final Set<UUID> temporaryExemptedPlayers = new HashSet<UUID>();
    private final Map<ResourcePackVersion, Set<ResourcePack>> resourcePacks = new HashMap<ResourcePackVersion, Set<ResourcePack>>();
    private final Map<UUID, ForcePackPlayer> waiting = new HashMap<UUID, ForcePackPlayer>();
    private @Nullable ForcePackWebServer webServer;
    private ConfigurationNode rootNode;
    private static ForcePackSponge INSTANCE;

    @Override
    public boolean exemptNextResourcePackSend(UUID uuid) {
        return this.temporaryExemptedPlayers.add(uuid);
    }

    @Inject
    public ForcePackSponge(PluginContainer pluginContainer, Logger logger, @ConfigDir(sharedRoot=false) Path configDir, Metrics.Factory metrics) {
        INSTANCE = this;
        this.pluginContainer = pluginContainer;
        this.logger = logger;
        this.configDir = configDir;
        this.scheduler = new SpongeScheduler(this);
        this.loadConfig();
        metrics.make(13677);
    }

    @Override
    public Set<ResourcePack> getResourcePacks() {
        return this.resourcePacks.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Listener
    public void onServerStarting(StartingEngineEvent<Server> event) {
        this.registerTranslations();
        PacketEvents.setAPI(SpongePacketEventsBuilder.build(this.pluginContainer));
        PacketEvents.getAPI().getSettings().debug(this.debug()).checkForUpdates(false);
        PacketEvents.getAPI().load();
        GeyserUtil.isGeyserInstalledHere = Sponge.pluginManager().plugin("geyser-sponge").isPresent();
        this.registerListeners();
        PacketEvents.getAPI().init();
        try {
            this.checkForServerProperties();
        }
        catch (IOException e) {
            this.getLogger().error("Failed to check for server properties resource pack", (Throwable)e);
        }
        Runnable run = () -> {
            if (this.getConfig().node(new Object[]{"web-server", "enabled"}).getBoolean()) {
                try {
                    this.getLogger().info("Enabling web server...");
                    this.getLogger().info("Downloading required dependencies, this might take a while! Subsequent startups will be faster.");
                    WebServerDependencyDownloader.download(this, this.configDir, x$0 -> this.log((String)x$0, new Object[0]));
                    this.getLogger().info("Finished downloading required dependencies.");
                    String configIp = this.getConfig().node(new Object[]{"web-server", "server-ip"}).getString("localhost");
                    String serverIp = !configIp.equals("localhost") ? configIp : ForcePackWebServer.getIp();
                    this.webServer = new ForcePackWebServer(this.configDir, this.getConfig().node(new Object[]{"web-server", "protocol"}).getString("http://"), serverIp, this.getConfig().node(new Object[]{"web-server", "port"}).getInt(8080), this.getConfig().node(new Object[]{"web-server", "port-on-url"}).getBoolean(true));
                    this.getLogger().info("Started web server.");
                }
                catch (IOException e) {
                    this.getLogger().error("Error starting web server: {}", (Object)e.getMessage());
                    this.getLogger().error("It is highly likely you need to open a port or change it in the config. Please see the config for further information.");
                    return;
                }
            }
            this.reload();
            this.getLogger().info("Completed loading resource packs.");
        };
        if (this.getConfig().node(new Object[]{"load-last"}).getBoolean()) {
            this.scheduler.registerInitTask(run);
        } else {
            run.run();
        }
        if (GeyserUtil.isGeyserInstalledHere && !this.getConfig().node(new Object[]{"Server", "geyser"}).getBoolean()) {
            this.getLogger().warn("Geyser is installed but Geyser support is not enabled.");
        } else if (!GeyserUtil.isGeyserInstalledHere && this.getConfig().node(new Object[]{"Server", "geyser"}).getBoolean()) {
            this.getLogger().warn("Geyser is not installed but Geyser support is enabled.");
        }
    }

    public Set<ResourcePack> getPacksForVersion(ServerPlayer player) {
        int protocolVersion = ProtocolUtil.getProtocolVersion(player);
        return this.getPacksForVersion(protocolVersion);
    }

    public void processWaitingResourcePack(ServerPlayer player, UUID packId) {
        UUID playerId = player.uniqueId();
        if (ProtocolUtil.getProtocolVersion(player) < 765) {
            this.removeFromWaiting(player);
            return;
        }
        ForcePackPlayer newPlayer = this.waiting.computeIfPresent(playerId, (a, forcePackPlayer) -> {
            Set<ResourcePack> packs = forcePackPlayer.getWaitingPacks();
            packs.removeIf(pack -> pack.getUUID().equals(packId));
            return forcePackPlayer;
        });
        if (newPlayer == null || newPlayer.getWaitingPacks().isEmpty()) {
            this.removeFromWaiting(player);
        }
    }

    public Optional<ForcePackPlayer> getForcePackPlayer(ServerPlayer player) {
        return Optional.ofNullable(this.waiting.get(player.uniqueId()));
    }

    public boolean isWaiting(ServerPlayer player) {
        return this.waiting.containsKey(player.uniqueId());
    }

    public boolean isWaitingFor(ServerPlayer player, UUID packId) {
        if (!this.isWaiting(player)) {
            return false;
        }
        if (ProtocolUtil.getProtocolVersion(player) < 765) {
            return true;
        }
        Set<ResourcePack> waitingPacks = this.waiting.get(player.uniqueId()).getWaitingPacks();
        return waitingPacks.stream().anyMatch(pack -> pack.getUUID().equals(packId));
    }

    public void removeFromWaiting(ServerPlayer player) {
        this.waiting.remove(player.uniqueId());
    }

    public void addToWaiting(UUID uuid, @NonNull Set<ResourcePack> packs) {
        this.waiting.compute(uuid, (a, existing) -> {
            ForcePackPlayer newPlayer = existing != null ? existing : new ForcePackSpongePlayer((ServerPlayer)Sponge.server().player(uuid).orElseThrow());
            newPlayer.getWaitingPacks().addAll(packs);
            return newPlayer;
        });
    }

    public Optional<ForcePackWebServer> getWebServer() {
        return Optional.ofNullable(this.webServer);
    }

    public void reload() {
        if (this.getConfig().node(new Object[]{"velocity-mode"}).getBoolean()) {
            return;
        }
        this.resourcePacks.clear();
        this.getWebServer().ifPresent(ForcePackWebServer::clearHostedPacks);
        ConfigurationNode packs = this.getConfig().node(new Object[]{"Server", "packs"});
        boolean success = true;
        try {
            for (Object key : packs.childrenMap().keySet()) {
                String versionId = key.toString();
                ResourcePackVersion version = this.getVersionFromId(versionId);
                ConfigurationNode packSection = packs.node(new Object[]{versionId});
                List urls = packSection.hasChild(new Object[]{"urls"}) ? packSection.node(new Object[]{"urls"}).getList(String.class, new ArrayList()) : List.of(packSection.node(new Object[]{"url"}).getString(""));
                List hashes = packSection.hasChild(new Object[]{"hashes"}) ? packSection.node(new Object[]{"hashes"}).getList(String.class, new ArrayList()) : List.of(packSection.node(new Object[]{"hash"}).getString(""));
                boolean generateHash = packSection.node(new Object[]{"generate-hash"}).getBoolean();
                if (!generateHash && urls.size() != hashes.size()) {
                    this.getLogger().error("There are not the same amount of URLs and hashes! Please provide a hash for every resource pack URL!");
                }
                for (int i = 0; i < urls.size(); ++i) {
                    String url = (String)urls.get(i);
                    String hash = i >= hashes.size() ? null : (String)hashes.get(i);
                    success = success && this.checkPack(version, url, generateHash, hash);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!success) {
            this.getLogger().error("Unable to load all resource packs correctly.");
        }
    }

    private boolean checkPack(@Nullable ResourcePackVersion version, String url, boolean generateHash, @Nullable String hash) {
        if (((String)url).startsWith("forcepack://")) {
            File generatedFilePath = new File(String.valueOf(this.configDir) + File.separator + ((String)url).replace("forcepack://", ""));
            this.log("Using local resource pack host for " + (String)url + " (" + String.valueOf(generatedFilePath) + ")", new Object[0]);
            if (this.webServer == null) {
                this.getLogger().error("Unable to locally host resource pack '{}' because the web server is not active!", url);
                return false;
            }
            this.webServer.addHostedPack(generatedFilePath);
            url = this.webServer.getHostedEndpoint((String)url);
        }
        this.checkForRehost((String)url);
        this.checkValidEnding((String)url);
        AtomicInteger sizeMB = new AtomicInteger();
        ResourcePackURLData data = null;
        if (generateHash) {
            this.getLogger().info("Auto-generating resource pack hash.");
            try {
                data = HashingUtil.performPackCheck((String)url, hash);
                sizeMB.set(data.getSize());
                hash = data.getUrlHash();
                this.getLogger().info("Size of resource pack: {} MB", (Object)sizeMB.get());
                this.getLogger().info("Auto-generated resource pack hash: {}", (Object)hash);
            }
            catch (Exception e) {
                this.getLogger().error("Unable to auto-generate resource pack hash, reverting to config setting", (Throwable)e);
            }
        }
        if (this.getConfig().node(new Object[]{"enable-mc-164316-fix"}).getBoolean()) {
            url = (String)url + "#" + hash;
        }
        if (this.getConfig().node(new Object[]{"Server", "verify"}).getBoolean()) {
            try {
                Consumer<Integer> consumer = size -> {
                    this.getLogger().info("Performing version size check...");
                    for (ClientVersion clientVersion : ClientVersion.values()) {
                        String sizeStr = clientVersion.getDisplay() + " (" + clientVersion.getMaxSizeMB() + " MB): ";
                        if (clientVersion.getMaxSizeMB() < size) {
                            Sponge.systemSubject().sendMessage((Component)Component.text((String)(sizeStr + "Unsupported."), (TextColor)NamedTextColor.RED));
                            continue;
                        }
                        Sponge.systemSubject().sendMessage((Component)Component.text((String)(sizeStr + "Supported."), (TextColor)NamedTextColor.GREEN));
                    }
                    sizeMB.set((int)size);
                };
                if (data == null) {
                    data = HashingUtil.performPackCheck((String)url, hash);
                }
                consumer.accept(data.getSize());
                if (hash == null || !hash.equalsIgnoreCase(data.getUrlHash())) {
                    this.getLogger().error("-----------------------------------------------");
                    this.getLogger().error("Your hash does not match the URL file provided!");
                    this.getLogger().error("The URL hash returned: {}", (Object)data.getUrlHash());
                    this.getLogger().error("Your config hash returned: {}", (Object)data.getConfigHash());
                    this.getLogger().error("Please provide a correct SHA-1 hash!");
                    this.getLogger().error("-----------------------------------------------");
                } else {
                    Sponge.systemSubject().sendMessage((Component)Component.text((String)"Hash verification complete.", (TextColor)NamedTextColor.GREEN));
                }
            }
            catch (Exception e) {
                this.getLogger().error("Please provide a correct SHA-1 hash/url!", (Throwable)e);
                return false;
            }
        }
        Object finalUrl = url;
        String finalHash = hash;
        this.resourcePacks.compute(version, (arg_0, arg_1) -> this.lambda$checkPack$7((String)finalUrl, finalHash, sizeMB, version, arg_0, arg_1));
        return true;
    }

    @Listener
    public void onRegisterChannels(RegisterChannelEvent event) {
        if (!this.getConfig().node(new Object[]{"velocity-mode"}).getBoolean()) {
            return;
        }
        this.getLogger().info("Enabled velocity listener");
        RawDataChannel channel = (RawDataChannel)event.register(ResourceKey.of((String)"forcepack", (String)"status"), RawDataChannel.class);
        channel.play().addHandler(ServerConnectionState.Game.class, (message, state) -> {
            ServerPlayer player = state.player();
            String data = new String(message.readBytes(message.available()));
            String[] split = data.split(";");
            this.log("Posted event", new Object[0]);
            ResourcePackStatus status = ResourcePackStatus.valueOf((String)split[1]);
            UUID packId = UUID.fromString(split[0]);
            boolean proxyRemove = Boolean.parseBoolean(split[2]);
            this.getScheduler().executeAsync(() -> Sponge.eventManager().post((Event)new MultiVersionResourcePackStatusEvent(player, packId, status, true, proxyRemove)));
        });
    }

    private void registerListeners() {
        EventManager pm = Sponge.eventManager();
        pm.registerListeners(this.pluginContainer, (Object)new ResourcePackListener(this), MethodHandles.lookup());
        pm.registerListeners(this.pluginContainer, (Object)new ExemptionListener(this), MethodHandles.lookup());
        PacketEvents.getAPI().getEventManager().registerListeners(new PacketListener(this));
    }

    @Listener
    private void onRegisterCommands(RegisterCommandEvent<Command.Parameterized> event) {
        new Commands(this, event.registryHolder());
    }

    public ConfigurationNode getConfig() {
        return this.rootNode;
    }

    public void reloadConfig() {
        this.loadConfig();
    }

    private void loadConfig() {
        if (!this.configDir.toFile().exists()) {
            this.configDir.toFile().mkdirs();
        }
        Path configPath = this.configDir.resolve("config.yml");
        try {
            Files.copy((InputStream)this.pluginContainer.openResource("/assets/forcepack/config.yml").orElseThrow(), configPath, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configPath)).build();
        try {
            this.rootNode = loader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkValidEnding(String url) {
        if (!this.isValidEnding(url)) {
            this.getLogger().error("Your URL has an invalid or unknown format. URLs must have no redirects and use the .zip extension. If you are using Dropbox, change dl=0 to dl=1.");
            this.getLogger().error("ForcePack will still load in the event this check is incorrect. Please make an issue or pull request if this is so.");
        }
    }

    private void checkForRehost(String url) {
        if (this.isDefaultHost(url)) {
            this.getLogger().warn(String.format("[%s] You are using a default resource pack provided by the plugin. ", url) + " It's highly recommended you re-host this pack using the webserver or on a CDN such as https://mc-packs.net for faster load times. Leaving this as default potentially sends a lot of requests to my personal web server, which isn't ideal!");
            this.getLogger().warn("ForcePack will still load and function like normally.");
        }
        this.getBlacklistedSite(url).ifPresent(blacklistedSite -> this.getLogger().error("Invalid resource pack site used! '{}' cannot be used for hosting resource packs!", blacklistedSite));
    }

    private void checkForServerProperties() throws IOException {
        Properties properties = new Properties();
        try (FileReader reader = new FileReader("./server.properties");){
            properties.load(reader);
            String packUrl = properties.getProperty("resource-pack");
            if (packUrl != null && !packUrl.isEmpty()) {
                this.getLogger().error("You have a resource pack set in server.properties!");
                this.getLogger().error("This will cause ForcePack to not function correctly. You MUST remove the resource pack URL from server.properties!");
            }
        }
    }

    private void registerTranslations() {
        TranslationRegistry translationRegistry = TranslationRegistry.create((Key)Key.key((String)"forcepack", (String)"translations"));
        translationRegistry.defaultLocale(Locale.US);
        try {
            FileSystemUtils.visitResources(ForcePackSponge.class, path -> {
                this.getLogger().info("Loading localizations...");
                try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                    stream.forEach(file -> {
                        if (!Files.isRegularFile(file, new LinkOption[0])) {
                            return;
                        }
                        String filename = com.google.common.io.Files.getNameWithoutExtension((String)file.getFileName().toString());
                        String localeName = filename.replace("messages_", "").replace("messages", "").replace('_', '-');
                        Locale locale = localeName.isEmpty() ? Locale.US : Locale.forLanguageTag(localeName);
                        translationRegistry.registerAll(locale, ResourceBundle.getBundle("com/convallyria/forcepack/sponge/l10n/messages", locale), false);
                        this.getLogger().info("Loaded translations for {}.", (Object)locale.getDisplayName());
                    });
                }
                catch (IOException e) {
                    this.getLogger().warn("Encountered an I/O error whilst loading translations", (Throwable)e);
                }
            }, "com", "convallyria", "forcepack", "sponge", "l10n");
        }
        catch (IOException e) {
            this.getLogger().warn("Encountered an I/O error whilst loading translations", (Throwable)e);
            return;
        }
        GlobalTranslator.translator().addSource((Translator)translationRegistry);
    }

    public PluginContainer pluginContainer() {
        return this.pluginContainer;
    }

    @Override
    public PlatformScheduler<?> getScheduler() {
        return this.scheduler;
    }

    public boolean debug() {
        return this.getConfig().node(new Object[]{"Server", "debug"}).getBoolean();
    }

    @Override
    public void log(String info, Object ... format) {
        if (this.debug()) {
            this.getLogger().info(String.format(info, format));
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static ForcePackAPI getAPI() {
        return ForcePackSponge.getInstance();
    }

    public static ForcePackSponge getInstance() {
        return INSTANCE;
    }

    private /* synthetic */ Set lambda$checkPack$7(String finalUrl, String finalHash, AtomicInteger sizeMB, ResourcePackVersion version, ResourcePackVersion u, Set existingPacks) {
        Set packs = existingPacks == null ? new HashSet() : existingPacks;
        SpongeResourcePack pack = new SpongeResourcePack(this, finalUrl, finalHash, sizeMB.get(), version);
        packs.add(pack);
        this.getLogger().info("Generated resource pack ({}) for version {} with id {}", (Object)pack.getURL(), version == null ? "all" : version, (Object)pack.getUUID());
        return packs;
    }
}

