/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.sponge.command;

import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.utils.GeyserUtil;
import com.convallyria.forcepack.sponge.ForcePackSponge;
import com.convallyria.forcepack.sponge.event.ForcePackReloadEvent;
import com.convallyria.forcepack.sponge.util.ProtocolUtil;
import forcepack.libs.pe.api.PacketEvents;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerResourcePackRemove;
import forcepack.libs.sponge.cloud.annotations.Argument;
import forcepack.libs.sponge.cloud.annotations.Command;
import forcepack.libs.sponge.cloud.annotations.CommandDescription;
import forcepack.libs.sponge.cloud.annotations.Default;
import forcepack.libs.sponge.cloud.annotations.Permission;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Event;

public class ForcePackCommand {
    private final ForcePackSponge plugin;

    public ForcePackCommand(ForcePackSponge plugin) {
        this.plugin = plugin;
    }

    @CommandDescription(value="Default ForcePack command")
    @Command(value="forcepack")
    public void onDefault(CommandCause sender) {
        sender.sendMessage((Component)Component.text((String)"ForcePack by SamB440. Type /forcepack help for help.", (TextColor)NamedTextColor.GREEN));
    }

    @CommandDescription(value="Reloads the plugin config along with the resource pack")
    @Permission(value={"forcepack.reload"})
    @Command(value="forcepack reload [send]")
    public void onReload(CommandCause sender, @Argument(value="send", description="Whether to send the updated resource pack to players") @Default(value="true") boolean send) {
        sender.sendMessage((Component)Component.text((String)"Reloading...", (TextColor)NamedTextColor.GREEN));
        this.plugin.reloadConfig();
        this.plugin.reload();
        PacketEvents.getAPI().getSettings().debug(this.plugin.debug());
        Sponge.eventManager().post((Event)new ForcePackReloadEvent());
        if (!this.plugin.getConfig().node(new Object[]{"velocity-mode"}).getBoolean() && send) {
            for (ServerPlayer player : Sponge.server().onlinePlayers()) {
                if (this.plugin.isWaiting(player)) continue;
                boolean geyser = this.plugin.getConfig().node(new Object[]{"Server", "geyser"}).getBoolean() && GeyserUtil.isBedrockPlayer(player.uniqueId());
                boolean canBypass = player.hasPermission("forcepack.bypass") && this.plugin.getConfig().node(new Object[]{"Server", "bypass-permission"}).getBoolean();
                this.plugin.log(player.name() + "'s exemptions: geyser, " + geyser + ". permission, " + canBypass + ".", new Object[0]);
                if (geyser || canBypass) continue;
                player.sendMessage((Component)Component.translatable((String)"forcepack.reloading"));
                Set<ResourcePack> resourcePacks = this.plugin.getPacksForVersion(player);
                this.plugin.addToWaiting(player.uniqueId(), resourcePacks);
                if (ProtocolUtil.getProtocolVersion(player) >= 765) {
                    ProtocolUtil.sendPacketBypassingVia(player, new WrapperPlayServerResourcePackRemove((UUID)null));
                }
                resourcePacks.forEach(pack -> pack.setResourcePack(player.uniqueId()));
            }
        }
        sender.sendMessage((Component)Component.text((String)"Done!", (TextColor)NamedTextColor.GREEN));
    }
}

