/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.sponge.listener;

import com.convallyria.forcepack.sponge.ForcePackSponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;

public class ExemptionListener {
    private final ForcePackSponge plugin;

    public ExemptionListener(ForcePackSponge plugin) {
        this.plugin = plugin;
    }

    @Listener
    public void onDamage(DamageEntityEvent event) {
        ServerPlayer damaged;
        if (!this.plugin.getConfig().node(new Object[]{"prevent-damage"}).getBoolean()) {
            return;
        }
        event.cause().first(ServerPlayer.class).ifPresent(damager -> {
            if (damager.equals((Object)event.entity())) {
                return;
            }
            if (this.plugin.isWaiting((ServerPlayer)damager)) {
                event.setCancelled(true);
                this.plugin.log("Cancelled damage for damager '" + damager.name() + "' due to resource pack not applied.", new Object[0]);
            }
        });
        if (event.entity() instanceof ServerPlayer && this.plugin.isWaiting(damaged = (ServerPlayer)event.entity())) {
            event.setCancelled(true);
            this.plugin.log("Cancelled damage for player '" + damaged.name() + "' due to resource pack not applied.", new Object[0]);
        }
    }

    @Listener
    public void onMove(MoveEntityEvent event) {
        if (!(event.entity() instanceof ServerPlayer)) {
            return;
        }
        if (!this.plugin.getConfig().node(new Object[]{"prevent-movement"}).getBoolean()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.entity();
        if (this.plugin.isWaiting(player)) {
            event.setCancelled(true);
            this.plugin.log("Cancelled movement for player '" + player.name() + "' due to resource pack not applied.", new Object[0]);
        }
    }
}

