/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.sponge.listener;

import com.convallyria.forcepack.sponge.ForcePackSponge;
import com.convallyria.forcepack.sponge.event.MultiVersionResourcePackStatusEvent;
import forcepack.libs.pe.api.event.PacketListenerAbstract;
import forcepack.libs.pe.api.event.PacketReceiveEvent;
import forcepack.libs.pe.api.protocol.packettype.PacketType;
import forcepack.libs.pe.api.wrapper.play.client.WrapperPlayClientResourcePackStatus;
import java.util.UUID;
import net.kyori.adventure.resource.ResourcePackStatus;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Event;

public class PacketListener
extends PacketListenerAbstract {
    private final ForcePackSponge plugin;

    public PacketListener(ForcePackSponge plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.RESOURCE_PACK_STATUS) {
            ServerPlayer player = Sponge.server().player(event.getUser().getUUID()).orElse(null);
            if (player == null) {
                this.plugin.getLogger().warn("Unable to get player for resource pack status!?!? {}, {}", (Object)event.getUser(), event.getPlayer());
                return;
            }
            this.plugin.log("Received packet resource pack status from " + player.name() + " (version: " + event.getServerVersion().getReleaseName() + ")", new Object[0]);
            WrapperPlayClientResourcePackStatus status = new WrapperPlayClientResourcePackStatus(event);
            WrapperPlayClientResourcePackStatus.Result result = status.getResult();
            UUID packId = status.getPackId();
            MultiVersionResourcePackStatusEvent packEvent = new MultiVersionResourcePackStatusEvent(player, packId, ResourcePackStatus.valueOf((String)result.name()), false, false);
            if (Sponge.eventManager().post((Event)packEvent)) {
                event.setCancelled(true);
            }
        }
    }
}

