/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.sponge.listener;

import com.convallyria.forcepack.api.check.SpoofCheck;
import com.convallyria.forcepack.api.player.ForcePackPlayer;
import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.schedule.PlatformScheduler;
import com.convallyria.forcepack.api.utils.ClientVersion;
import com.convallyria.forcepack.api.utils.GeyserUtil;
import com.convallyria.forcepack.sponge.ForcePackSponge;
import com.convallyria.forcepack.sponge.event.ForcePackReloadEvent;
import com.convallyria.forcepack.sponge.event.MultiVersionResourcePackStatusEvent;
import com.convallyria.forcepack.sponge.util.ProtocolUtil;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.living.player.ResourcePackStatusEvent;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class ResourcePackListener {
    private final ForcePackSponge plugin;
    private final Map<UUID, Long> sentAccept = new ConcurrentHashMap<UUID, Long>();

    public ResourcePackListener(ForcePackSponge plugin) {
        this.plugin = plugin;
    }

    @Listener
    public void onStatus(MultiVersionResourcePackStatusEvent event) {
        ServerPlayer player = event.getPlayer();
        UUID id = event.getID();
        boolean geyser = this.getConfig().node(new Object[]{"Server", "geyser"}).getBoolean() && GeyserUtil.isBedrockPlayer(player.uniqueId());
        boolean canBypass = player.hasPermission("forcepack.bypass") && this.getConfig().node(new Object[]{"Server", "bypass-permission"}).getBoolean();
        this.plugin.log(player.name() + "'s exemptions: geyser, " + geyser + ". permission, " + canBypass + ".", new Object[0]);
        if (canBypass || geyser) {
            return;
        }
        if (this.plugin.temporaryExemptedPlayers.remove(player.uniqueId())) {
            this.plugin.log("Ignoring player " + player.name() + " as they have a one-off exemption.", new Object[0]);
            return;
        }
        ResourcePackStatus status = event.getStatus();
        this.plugin.log(player.name() + " sent status: " + String.valueOf(status), new Object[0]);
        boolean velocityMode = this.getConfig().node(new Object[]{"velocity-mode"}).getBoolean();
        if (!velocityMode && this.tryValidateHacks(player, event, status)) {
            return;
        }
        if (!event.isProxy() && !this.plugin.isWaitingFor(player, id)) {
            this.plugin.log("Ignoring resource pack " + String.valueOf(id) + " because it wasn't set by ForcePack.", new Object[0]);
            return;
        }
        if (event.isProxy()) {
            this.plugin.log("Resource pack with id " + String.valueOf(id) + " sent by proxy. Removal state: " + event.isProxyRemove(), new Object[0]);
        }
        if (status != ResourcePackStatus.ACCEPTED && status != ResourcePackStatus.DOWNLOADED) {
            if (event.isProxy()) {
                if (event.isProxyRemove()) {
                    this.plugin.removeFromWaiting(player);
                }
            } else {
                this.plugin.processWaitingResourcePack(player, id);
            }
        }
        try {
            for (String cmd : this.getConfig().node(new Object[]{"Server", "Actions", status.name(), "Commands"}).getList(String.class, new ArrayList())) {
                this.ensureMainThread(() -> {
                    try {
                        Sponge.server().commandManager().process(cmd.replace("[player]", player.name()));
                    }
                    catch (CommandException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        if (velocityMode) {
            this.plugin.getScheduler().executeOnMain(() -> this.callSpongeEvent(event));
            return;
        }
        boolean kick = this.getConfig().node(new Object[]{"Server", "Actions", status.name(), "kick"}).getBoolean();
        switch (status) {
            case ACCEPTED: {
                this.sentAccept.put(player.uniqueId(), System.currentTimeMillis());
                break;
            }
            case DECLINED: {
                this.ensureMainThread(() -> {
                    if (kick) {
                        player.kick((Component)Component.translatable((String)"forcepack.declined"));
                    } else {
                        player.sendMessage((Component)Component.translatable((String)"forcepack.declined"));
                    }
                });
                this.sentAccept.remove(player.uniqueId());
                break;
            }
            case DISCARDED: 
            case INVALID_URL: 
            case FAILED_RELOAD: 
            case FAILED_DOWNLOAD: {
                this.ensureMainThread(() -> {
                    if (kick) {
                        player.kick((Component)Component.translatable((String)"forcepack.download_failed"));
                    } else {
                        player.sendMessage((Component)Component.translatable((String)"forcepack.download_failed"));
                    }
                });
                this.sentAccept.remove(player.uniqueId());
                break;
            }
            case SUCCESSFULLY_LOADED: {
                if (kick) {
                    this.ensureMainThread(() -> player.kick((Component)Component.translatable((String)"forcepack.accepted")));
                    break;
                }
                this.ensureMainThread(() -> player.sendMessage((Component)Component.translatable((String)"forcepack.accepted")));
                boolean sendTitle = this.plugin.getConfig().node(new Object[]{"send-loading-title"}).getBoolean();
                if (!sendTitle) break;
                player.clearTitle();
            }
        }
    }

    private boolean tryValidateHacks(ServerPlayer player, MultiVersionResourcePackStatusEvent event, ResourcePackStatus status) {
        boolean tryPrevent = this.getConfig().node(new Object[]{"try-to-stop-fake-accept-hacks"}).getBoolean(true);
        if (!tryPrevent) {
            return false;
        }
        ForcePackPlayer forcePackPlayer = this.plugin.getForcePackPlayer(player).orElse(null);
        if (forcePackPlayer == null) {
            this.plugin.log("Not checking " + player.name() + " because they are not in waiting.", new Object[0]);
            return false;
        }
        boolean hasFailed = false;
        for (SpoofCheck check : forcePackPlayer.getChecks()) {
            SpoofCheck.CheckStatus checkStatus = check.receiveStatus(status.name(), x$0 -> this.plugin.log((String)x$0, new Object[0]));
            boolean bl = hasFailed = checkStatus == SpoofCheck.CheckStatus.FAILED;
            if (checkStatus != SpoofCheck.CheckStatus.CANCEL) continue;
            this.plugin.log("Cancelling status " + String.valueOf(status) + " as a check requested it.", new Object[0]);
            event.setCancelled(true);
            return true;
        }
        if (hasFailed) {
            this.plugin.log("Kicking player " + player.name() + " because they failed a check.", new Object[0]);
            this.ensureMainThread(() -> player.kick((Component)Component.translatable((String)"forcepack.download_failed")));
        }
        return hasFailed;
    }

    private void callSpongeEvent(final MultiVersionResourcePackStatusEvent event) {
        Sponge.eventManager().post((Event)new ResourcePackStatusEvent(){

            public ServerSideConnection connection() {
                return event.getPlayer().connection();
            }

            public GameProfile profile() {
                return event.getPlayer().profile();
            }

            public Optional<ServerPlayer> player() {
                return Optional.of(event.getPlayer());
            }

            public ResourcePackInfo pack() {
                return new ResourcePackInfo(){

                    @NotNull
                    public UUID id() {
                        return event.getID() == null ? UUID.randomUUID() : event.getID();
                    }

                    @NotNull
                    public URI uri() {
                        return URI.create("forcepack://proxy");
                    }

                    @NotNull
                    public String hash() {
                        return "forcepack-proxy";
                    }
                };
            }

            public ResourcePackStatus status() {
                return event.getStatus();
            }

            public Cause cause() {
                return Cause.of((EventContext)EventContext.empty(), (Object)ResourcePackListener.this.plugin);
            }
        });
    }

    @Listener
    public void onPlayerJoin(ServerSideConnectionEvent.Join event) {
        ServerPlayer player = event.player();
        boolean geyser = this.getConfig().node(new Object[]{"Server", "geyser"}).getBoolean() && GeyserUtil.isBedrockPlayer(player.uniqueId());
        boolean canBypass = player.hasPermission("forcepack.bypass") && this.getConfig().node(new Object[]{"Server", "bypass-permission"}).getBoolean();
        this.plugin.log(player.name() + "'s exemptions: geyser, " + geyser + ". permission, " + canBypass + ".", new Object[0]);
        if (canBypass || geyser) {
            return;
        }
        if (this.getConfig().node(new Object[]{"velocity-mode"}).getBoolean()) {
            this.plugin.log("Velocity mode is enabled", new Object[0]);
            this.plugin.addToWaiting(player.uniqueId(), Set.of());
            return;
        }
        Set<ResourcePack> packs = this.plugin.getPacksForVersion(player);
        if (packs.isEmpty()) {
            this.plugin.log("Warning: Packs for player " + player.name() + " are empty.", new Object[0]);
            return;
        }
        this.plugin.addToWaiting(player.uniqueId(), packs);
        for (ResourcePack pack : packs) {
            this.plugin.log("Sending pack " + String.valueOf(pack.getUUID()) + " to player " + player.name(), new Object[0]);
            int version = ProtocolUtil.getProtocolVersion(player);
            int maxSize = ClientVersion.getMaxSizeForVersion(version);
            boolean forceSend = this.getConfig().node(new Object[]{"Server", "force-invalid-size"}).getBoolean();
            if (!forceSend && pack.getSize() > maxSize) {
                if (!this.plugin.debug()) continue;
                this.plugin.getLogger().info("Not sending pack to {} because of excessive size for version {} ({}MB, {}MB).", (Object)player.name(), (Object)version, (Object)pack.getSize(), (Object)maxSize);
                continue;
            }
            this.plugin.getScheduler().executeOnMain(() -> this.runSetPackTask(player, pack, version));
        }
    }

    @Listener
    public void onReload(ForcePackReloadEvent event) {
        for (ServerPlayer onlinePlayer : Sponge.server().onlinePlayers()) {
            if (this.plugin.isWaiting(onlinePlayer)) continue;
            this.sentAccept.remove(onlinePlayer.uniqueId());
        }
    }

    private void runSetPackTask(ServerPlayer player, ResourcePack pack, int version) {
        AtomicReference<PlatformScheduler.ForcePackTask> task = new AtomicReference<PlatformScheduler.ForcePackTask>();
        Runnable packTask = () -> {
            PlatformScheduler.ForcePackTask acquired;
            boolean sendTitle;
            if (this.plugin.isWaiting(player)) {
                this.plugin.log("Sent resource pack to player", new Object[0]);
                pack.setResourcePack(player.uniqueId());
            }
            if ((sendTitle = this.plugin.getConfig().node(new Object[]{"send-loading-title"}).getBoolean()) && this.sentAccept.containsKey(player.uniqueId())) {
                player.showTitle(Title.title((Component)Component.translatable((String)"forcepack.download_start_title"), (Component)Component.translatable((String)"forcepack.download_start_subtitle"), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofMillis(1500L), (Duration)Duration.ofMillis(500L))));
            }
            if ((acquired = (PlatformScheduler.ForcePackTask)task.get()) != null && !this.plugin.isWaiting(player) && !this.sentAccept.containsKey(player.uniqueId())) {
                acquired.cancel();
            }
        };
        if (this.getConfig().node(new Object[]{"Server", "Update GUI"}).getBoolean() && version <= 340) {
            task.set(this.plugin.getScheduler().executeRepeating(packTask, 0L, this.getConfig().node(new Object[]{"Server", "Update GUI Speed"}).getInt(20)));
        } else {
            packTask.run();
        }
    }

    @Listener
    public void onQuit(ServerSideConnectionEvent.Leave event) {
        ServerPlayer player = event.player();
        this.plugin.removeFromWaiting(player);
        this.sentAccept.remove(player.uniqueId());
    }

    private void ensureMainThread(Runnable runnable) {
        this.plugin.getScheduler().executeOnMain(runnable);
    }

    private ConfigurationNode getConfig() {
        return this.plugin.getConfig();
    }
}

