/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.chat.clickevent;

import forcepack.libs.pe.api.manager.server.ServerVersion;
import forcepack.libs.pe.api.protocol.chat.clickevent.ClickEvent;
import forcepack.libs.pe.api.protocol.chat.clickevent.ClickEventAction;
import forcepack.libs.pe.api.protocol.chat.clickevent.ClickEventActions;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTInt;
import forcepack.libs.pe.api.protocol.nbt.NBTString;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ChangePageClickEvent
implements ClickEvent {
    private final int page;

    @ApiStatus.Obsolete
    public ChangePageClickEvent(String page) {
        this(Integer.parseInt(page));
    }

    public ChangePageClickEvent(int page) {
        this.page = page;
    }

    public static ChangePageClickEvent decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        int page = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5) ? compound.getNumberTagValueOrThrow("page").intValue() : Integer.parseInt(compound.getStringTagValueOrThrow("value"));
        return new ChangePageClickEvent(page);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, ChangePageClickEvent clickEvent) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5)) {
            compound.setTag("page", new NBTInt(clickEvent.page));
        } else {
            compound.setTag("value", new NBTString(Integer.toString(clickEvent.page)));
        }
    }

    @Override
    public ClickEventAction<?> getAction() {
        return ClickEventActions.CHANGE_PAGE;
    }

    @Override
    public net.kyori.adventure.text.event.ClickEvent asAdventure() {
        return net.kyori.adventure.text.event.ClickEvent.changePage((int)this.page);
    }

    public int getPage() {
        return this.page;
    }
}

