/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.entity.cow;

import forcepack.libs.pe.api.protocol.entity.cow.CowVariants;
import forcepack.libs.pe.api.protocol.entity.cow.StaticCowVariant;
import forcepack.libs.pe.api.protocol.mapper.CopyableEntity;
import forcepack.libs.pe.api.protocol.mapper.DeepComparableEntity;
import forcepack.libs.pe.api.protocol.mapper.MappedEntity;
import forcepack.libs.pe.api.protocol.nbt.NBT;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTString;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.resources.ResourceLocation;
import forcepack.libs.pe.api.util.adventure.AdventureIndexUtil;
import forcepack.libs.pe.api.util.mappings.TypesBuilderData;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import net.kyori.adventure.util.Index;
import org.jetbrains.annotations.Nullable;

public interface CowVariant
extends MappedEntity,
CopyableEntity<CowVariant>,
DeepComparableEntity {
    public ModelType getModelType();

    public ResourceLocation getAssetId();

    public static CowVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(CowVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, CowVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static CowVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String modelTypeString = compound.getStringTagValueOrNull("model");
        ModelType modelType = modelTypeString != null ? ModelType.getByName(modelTypeString) : ModelType.NORMAL;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticCowVariant(data, modelType, assetId);
    }

    public static NBT encode(CowVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("model", new NBTString(variant.getModelType().getName()));
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }

    public static enum ModelType {
        NORMAL("normal"),
        COLD("cold"),
        WARM("warm");

        private static final Index<String, ModelType> NAME_INDEX;
        private final String name;

        private ModelType(String name) {
            this.name = name;
        }

        public static ModelType getByName(String name) {
            return AdventureIndexUtil.indexValueOrThrow(NAME_INDEX, name);
        }

        public String getName() {
            return this.name;
        }

        static {
            NAME_INDEX = Index.create(ModelType.class, ModelType::getName);
        }
    }
}

