/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.entity.frog;

import forcepack.libs.pe.api.protocol.entity.frog.FrogVariants;
import forcepack.libs.pe.api.protocol.entity.frog.StaticFrogVariant;
import forcepack.libs.pe.api.protocol.mapper.CopyableEntity;
import forcepack.libs.pe.api.protocol.mapper.DeepComparableEntity;
import forcepack.libs.pe.api.protocol.mapper.MappedEntity;
import forcepack.libs.pe.api.protocol.nbt.NBT;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTString;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.resources.ResourceLocation;
import forcepack.libs.pe.api.util.mappings.TypesBuilderData;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface FrogVariant
extends MappedEntity,
CopyableEntity<FrogVariant>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public static FrogVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(FrogVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, FrogVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static FrogVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticFrogVariant(data, assetId);
    }

    public static NBT encode(FrogVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

