/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.item.jukebox;

import forcepack.libs.pe.api.protocol.item.jukebox.JukeboxSong;
import forcepack.libs.pe.api.protocol.item.jukebox.JukeboxSongs;
import forcepack.libs.pe.api.protocol.mapper.CopyableEntity;
import forcepack.libs.pe.api.protocol.mapper.DeepComparableEntity;
import forcepack.libs.pe.api.protocol.mapper.MappedEntity;
import forcepack.libs.pe.api.protocol.nbt.NBT;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTFloat;
import forcepack.libs.pe.api.protocol.nbt.NBTInt;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.protocol.sound.Sound;
import forcepack.libs.pe.api.util.mappings.TypesBuilderData;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public interface IJukeboxSong
extends MappedEntity,
CopyableEntity<IJukeboxSong>,
DeepComparableEntity {
    public Sound getSound();

    public Component getDescription();

    public float getLengthInSeconds();

    public int getComparatorOutput();

    @Deprecated
    public static IJukeboxSong decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        return IJukeboxSong.decode(nbt, PacketWrapper.createDummyWrapper(version), data);
    }

    public static IJukeboxSong decode(NBT nbt, PacketWrapper<?> wrapper, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Sound sound = compound.getOrThrow("sound_event", Sound::decode, wrapper);
        Component description = compound.getOrThrow("description", wrapper.getSerializers(), wrapper);
        float length = compound.getNumberTagOrThrow("length_in_seconds").getAsFloat();
        int comparator_output = compound.getNumberTagOrThrow("comparator_output").getAsInt();
        return new JukeboxSong(data, sound, description, length, comparator_output);
    }

    @Deprecated
    public static NBT encode(IJukeboxSong jukeboxSong, ClientVersion version) {
        return IJukeboxSong.encode(PacketWrapper.createDummyWrapper(version), jukeboxSong);
    }

    public static NBT encode(PacketWrapper<?> wrapper, IJukeboxSong song) {
        NBTCompound compound = new NBTCompound();
        compound.set("sound_event", song.getSound(), Sound::encode, wrapper);
        compound.set("description", song.getDescription(), wrapper.getSerializers(), wrapper);
        compound.setTag("length_in_seconds", new NBTFloat(song.getLengthInSeconds()));
        compound.setTag("comparator_output", new NBTInt(song.getComparatorOutput()));
        return compound;
    }

    public static IJukeboxSong read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(JukeboxSongs.getRegistry(), IJukeboxSong::readDirect);
    }

    public static IJukeboxSong readDirect(PacketWrapper<?> wrapper) {
        Sound sound = Sound.read(wrapper);
        Component description = wrapper.readComponent();
        float lengthInSeconds = wrapper.readFloat();
        int comparatorOutput = wrapper.readVarInt();
        return new JukeboxSong(null, sound, description, lengthInSeconds, comparatorOutput);
    }

    public static void write(PacketWrapper<?> wrapper, IJukeboxSong song) {
        wrapper.writeMappedEntityOrDirect(song, IJukeboxSong::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, IJukeboxSong song) {
        Sound.write(wrapper, song.getSound());
        wrapper.writeComponent(song.getDescription());
        wrapper.writeFloat(song.getLengthInSeconds());
        wrapper.writeVarInt(song.getComparatorOutput());
    }
}

