/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.impl.sponge.manager.server;

import forcepack.libs.pe.api.PacketEvents;
import forcepack.libs.pe.api.manager.server.ServerManager;
import forcepack.libs.pe.api.manager.server.ServerVersion;
import forcepack.libs.pe.api.util.PEVersion;
import org.spongepowered.api.Sponge;
import org.spongepowered.plugin.PluginContainer;

public class ServerManagerImpl
implements ServerManager {
    private ServerVersion serverVersion;

    private ServerVersion resolveVersionNoCache() {
        PEVersion latestVersion;
        PluginContainer plugin = (PluginContainer)PacketEvents.getAPI().getPlugin();
        String minecraftRelease = Sponge.platform().minecraftVersion().name();
        ServerVersion fallbackVersion = ServerVersion.getLatest();
        PEVersion version = PEVersion.fromString(minecraftRelease);
        if (version.isNewerThan(latestVersion = PEVersion.fromString(ServerVersion.getLatest().getReleaseName()))) {
            plugin.logger().warn("[packetevents] We currently do not support the minecraft version {}, so things might break. PacketEvents will behave as if the minecraft version were {}!", (Object)version, (Object)latestVersion);
            return ServerVersion.getLatest();
        }
        for (ServerVersion val : ServerVersion.reversedValues()) {
            if (!minecraftRelease.contains(val.getReleaseName())) continue;
            return val;
        }
        plugin.logger().warn("[packetevents] Your server software is preventing us from checking the server version. This is what we found: {}. We will assume the server version is {}...", (Object)minecraftRelease, (Object)fallbackVersion.name());
        return fallbackVersion;
    }

    @Override
    public ServerVersion getVersion() {
        if (this.serverVersion == null) {
            this.serverVersion = this.resolveVersionNoCache();
        }
        return this.serverVersion;
    }
}

