/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.impl.sponge.util;

import forcepack.libs.pe.api.PacketEvents;
import forcepack.libs.pe.api.manager.server.ServerVersion;
import forcepack.libs.pe.api.netty.buffer.ByteBufHelper;
import forcepack.libs.pe.api.netty.buffer.UnpooledByteBufAllocationHelper;
import forcepack.libs.pe.api.protocol.item.ItemStack;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.util.reflection.Reflection;
import forcepack.libs.pe.api.util.reflection.ReflectionObject;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;

public final class SpongeReflectionUtil {
    public static ServerVersion VERSION;
    public static Class<?> MINECRAFT_SERVER_CLASS;
    public static Class<?> NMS_PACKET_DATA_SERIALIZER_CLASS;
    public static Class<?> NMS_ITEM_STACK_CLASS;
    public static Class<?> ENTITY_PLAYER_CLASS;
    public static Class<?> NMS_MINECRAFT_KEY_CLASS;
    public static Class<?> PLAYER_CONNECTION_CLASS;
    public static Class<?> SERVER_COMMON_PACKETLISTENER_IMPL_CLASS;
    public static Class<?> SERVER_CONNECTION_CLASS;
    public static Class<?> NETWORK_MANAGER_CLASS;
    public static Class<?> NMS_NBT_COMPOUND_CLASS;
    public static Class<?> NBT_COMPRESSION_STREAM_TOOLS_CLASS;
    public static Class<?> STREAM_CODEC;
    public static Class<?> STREAM_DECODER;
    public static Class<?> STREAM_ENCODER;
    public static Class<?> REGISTRY_FRIENDLY_BYTE_BUF;
    public static Class<?> REGISTRY_ACCESS;
    public static Class<?> REGISTRY_ACCESS_FROZEN;
    public static Field BYTE_BUF_IN_PACKET_DATA_SERIALIZER;
    public static Field NMS_MK_KEY_FIELD;
    public static Method IS_DEBUGGING;
    public static Method READ_NBT_FROM_STREAM_METHOD;
    public static Method WRITE_NBT_TO_STREAM_METHOD;
    public static Method STREAM_DECODER_DECODE;
    public static Method STREAM_ENCODER_ENCODE;
    private static Constructor<?> REGISTRY_FRIENDLY_BYTE_BUF_CONSTRUCTOR;
    private static Object MINECRAFT_SERVER_CONNECTION_INSTANCE;
    private static Object ITEM_STACK_OPTIONAL_STREAM_CODEC;
    private static Object MINECRAFT_SERVER_REGISTRY_ACCESS;

    private static void initConstructors() {
        try {
            REGISTRY_FRIENDLY_BYTE_BUF_CONSTRUCTOR = REGISTRY_FRIENDLY_BYTE_BUF.getConstructor(ByteBuf.class, REGISTRY_ACCESS);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private static void initMethods() {
        IS_DEBUGGING = Reflection.getMethod(MINECRAFT_SERVER_CLASS, "isDebugging", 0);
        READ_NBT_FROM_STREAM_METHOD = Reflection.getMethod(NBT_COMPRESSION_STREAM_TOOLS_CLASS, 0, DataInputStream.class);
        if (READ_NBT_FROM_STREAM_METHOD == null) {
            READ_NBT_FROM_STREAM_METHOD = Reflection.getMethod(NBT_COMPRESSION_STREAM_TOOLS_CLASS, 0, DataInput.class);
        }
        WRITE_NBT_TO_STREAM_METHOD = Reflection.getMethod(NBT_COMPRESSION_STREAM_TOOLS_CLASS, 0, NMS_NBT_COMPOUND_CLASS, DataOutput.class);
        STREAM_DECODER_DECODE = STREAM_DECODER.getMethods()[0];
        STREAM_ENCODER_ENCODE = STREAM_ENCODER.getMethods()[0];
    }

    private static void initFields() {
        BYTE_BUF_IN_PACKET_DATA_SERIALIZER = Reflection.getField(NMS_PACKET_DATA_SERIALIZER_CLASS, ByteBuf.class, 0, true);
        NMS_MK_KEY_FIELD = Reflection.getField(NMS_MINECRAFT_KEY_CLASS, "key");
    }

    private static void initClasses() {
        MINECRAFT_SERVER_CLASS = SpongeReflectionUtil.getServerClass("server.MinecraftServer");
        NMS_PACKET_DATA_SERIALIZER_CLASS = SpongeReflectionUtil.getServerClass("network.FriendlyByteBuf");
        NMS_ITEM_STACK_CLASS = SpongeReflectionUtil.getServerClass("world.item.ItemStack");
        NMS_MINECRAFT_KEY_CLASS = SpongeReflectionUtil.getServerClass("resources.ResourceLocation");
        ENTITY_PLAYER_CLASS = SpongeReflectionUtil.getServerClass("server.level.ServerPlayer");
        PLAYER_CONNECTION_CLASS = SpongeReflectionUtil.getServerClass("server.network.ServerGamePacketListenerImpl");
        SERVER_COMMON_PACKETLISTENER_IMPL_CLASS = SpongeReflectionUtil.getServerClass("server.network.ServerCommonPacketListenerImpl");
        SERVER_CONNECTION_CLASS = SpongeReflectionUtil.getServerClass("server.network.ServerConnectionListener");
        NETWORK_MANAGER_CLASS = SpongeReflectionUtil.getServerClass("network.Connection");
        NMS_NBT_COMPOUND_CLASS = SpongeReflectionUtil.getServerClass("nbt.CompoundTag");
        NBT_COMPRESSION_STREAM_TOOLS_CLASS = SpongeReflectionUtil.getServerClass("nbt.NbtIo");
        STREAM_CODEC = Reflection.getClassByNameWithoutException("net.minecraft.network.codec.StreamCodec");
        STREAM_DECODER = Reflection.getClassByNameWithoutException("net.minecraft.network.codec.StreamDecoder");
        STREAM_ENCODER = Reflection.getClassByNameWithoutException("net.minecraft.network.codec.StreamEncoder");
        REGISTRY_FRIENDLY_BYTE_BUF = Reflection.getClassByNameWithoutException("net.minecraft.network.RegistryFriendlyByteBuf");
        REGISTRY_ACCESS = SpongeReflectionUtil.getServerClass("core.RegistryAccess");
        REGISTRY_ACCESS_FROZEN = SpongeReflectionUtil.getServerClass("core.RegistryAccess$Frozen");
    }

    private static void initObjects() {
        try {
            if (VERSION.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                ITEM_STACK_OPTIONAL_STREAM_CODEC = Reflection.getField(NMS_ITEM_STACK_CLASS, STREAM_CODEC, 0).get(null);
            }
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
    }

    public static void init() {
        VERSION = PacketEvents.getAPI().getServerManager().getVersion();
        SpongeReflectionUtil.initClasses();
        SpongeReflectionUtil.initFields();
        SpongeReflectionUtil.initMethods();
        SpongeReflectionUtil.initConstructors();
        SpongeReflectionUtil.initObjects();
    }

    @Nullable
    public static Class<?> getServerClass(String modern) {
        return Reflection.getClassByNameWithoutException("net.minecraft." + modern);
    }

    public static boolean isMinecraftServerInstanceDebugging() {
        if (IS_DEBUGGING != null) {
            try {
                return (Boolean)IS_DEBUGGING.invoke((Object)Sponge.server(), new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                IS_DEBUGGING = null;
                return false;
            }
        }
        return false;
    }

    public static Object getMinecraftServerConnectionInstance() {
        if (MINECRAFT_SERVER_CONNECTION_INSTANCE == null) {
            try {
                MINECRAFT_SERVER_CONNECTION_INSTANCE = Reflection.getField(MINECRAFT_SERVER_CLASS, SERVER_CONNECTION_CLASS, 0).get(Sponge.server());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return MINECRAFT_SERVER_CONNECTION_INSTANCE;
    }

    public static Class<?> getNettyClass(String name) {
        return Reflection.getClassByNameWithoutException("io.netty." + name);
    }

    public static List<Object> getNetworkManagers() {
        ReflectionObject serverConnectionWrapper = new ReflectionObject(SpongeReflectionUtil.getMinecraftServerConnectionInstance());
        int i = 0;
        while (true) {
            try {
                List list = serverConnectionWrapper.readObject(i, List.class);
                for (Object obj : list) {
                    if (!obj.getClass().isAssignableFrom(NETWORK_MANAGER_CLASS)) continue;
                    return list;
                }
            }
            catch (Exception ex) {
                break;
            }
            ++i;
        }
        return serverConnectionWrapper.readObject(1, List.class);
    }

    public static Object getNetworkManager(ServerPlayer player) {
        Object playerConnection = SpongeReflectionUtil.getPlayerConnection(player);
        if (playerConnection == null) {
            return null;
        }
        Class<?> playerConnectionClass = SERVER_COMMON_PACKETLISTENER_IMPL_CLASS != null ? SERVER_COMMON_PACKETLISTENER_IMPL_CLASS : PLAYER_CONNECTION_CLASS;
        ReflectionObject wrapper = new ReflectionObject(playerConnection, playerConnectionClass);
        try {
            return wrapper.readObject(0, NETWORK_MANAGER_CLASS);
        }
        catch (Exception ex) {
            try {
                playerConnection = wrapper.read(0, PLAYER_CONNECTION_CLASS);
                wrapper = new ReflectionObject(playerConnection, PLAYER_CONNECTION_CLASS);
                return wrapper.readObject(0, NETWORK_MANAGER_CLASS);
            }
            catch (Exception ex2) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    public static Object getChannel(ServerPlayer player) {
        Object networkManager = SpongeReflectionUtil.getNetworkManager(player);
        if (networkManager == null) {
            return null;
        }
        ReflectionObject wrapper = new ReflectionObject(networkManager, NETWORK_MANAGER_CLASS);
        return wrapper.readObject(0, Channel.class);
    }

    public static Object getPlayerConnection(ServerPlayer player) {
        ReflectionObject wrappedEntityPlayer = new ReflectionObject(player, ENTITY_PLAYER_CLASS);
        return wrappedEntityPlayer.readObject(0, PLAYER_CONNECTION_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemStack decodeSpongeItemStack(org.spongepowered.api.item.inventory.ItemStack in) {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        try {
            Object packetDataSerializer = SpongeReflectionUtil.createPacketDataSerializer(buffer);
            SpongeReflectionUtil.writeNMSItemStackPacketDataSerializer(packetDataSerializer, in);
            PacketWrapper<?> wrapper = PacketWrapper.createUniversalPacketWrapper(buffer);
            ItemStack itemStack = wrapper.readItemStack();
            return itemStack;
        }
        finally {
            ByteBufHelper.release(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static org.spongepowered.api.item.inventory.ItemStack encodeSpongeItemStack(ItemStack in) {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        try {
            PacketWrapper<?> wrapper = PacketWrapper.createUniversalPacketWrapper(buffer);
            wrapper.writeItemStack(in);
            Object packetDataSerializer = SpongeReflectionUtil.createPacketDataSerializer(wrapper.getBuffer());
            Object nmsItemStack = SpongeReflectionUtil.readNMSItemStackPacketDataSerializer(packetDataSerializer);
            org.spongepowered.api.item.inventory.ItemStack itemStack = (org.spongepowered.api.item.inventory.ItemStack)nmsItemStack;
            return itemStack;
        }
        finally {
            ByteBufHelper.release(buffer);
        }
    }

    public static Object createPacketDataSerializer(Object byteBuf) {
        try {
            return REGISTRY_FRIENDLY_BYTE_BUF_CONSTRUCTOR.newInstance(byteBuf, SpongeReflectionUtil.getFrozenRegistryAccess());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object readNMSItemStackPacketDataSerializer(Object packetDataSerializer) {
        try {
            return STREAM_DECODER_DECODE.invoke(ITEM_STACK_OPTIONAL_STREAM_CODEC, packetDataSerializer);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getFrozenRegistryAccess() {
        if (MINECRAFT_SERVER_REGISTRY_ACCESS == null) {
            try {
                MINECRAFT_SERVER_REGISTRY_ACCESS = Reflection.getMethod(MINECRAFT_SERVER_CLASS, REGISTRY_ACCESS_FROZEN, 0).invoke((Object)Sponge.server(), new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }
        return MINECRAFT_SERVER_REGISTRY_ACCESS;
    }

    public static Object writeNMSItemStackPacketDataSerializer(Object packetDataSerializer, Object nmsItemStack) {
        try {
            return STREAM_ENCODER_ENCODE.invoke(ITEM_STACK_OPTIONAL_STREAM_CODEC, packetDataSerializer, nmsItemStack);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NBTCompound fromMinecraftNBT(Object nbtCompound) {
        byte[] bytes;
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
             DataOutputStream stream = new DataOutputStream(byteStream);){
            SpongeReflectionUtil.writeNmsNbtToStream(nbtCompound, stream);
            bytes = byteStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Object buffer = UnpooledByteBufAllocationHelper.wrappedBuffer(bytes);
        PacketWrapper<?> wrapper = PacketWrapper.createUniversalPacketWrapper(buffer);
        NBTCompound nbt = wrapper.readNBT();
        ByteBufHelper.release(buffer);
        return nbt;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object toMinecraftNBT(NBTCompound nbtCompound) {
        Object buffer = UnpooledByteBufAllocationHelper.buffer();
        PacketWrapper<?> wrapper = PacketWrapper.createUniversalPacketWrapper(buffer);
        wrapper.writeNBT(nbtCompound);
        byte[] bytes = ByteBufHelper.copyBytes(buffer);
        ByteBufHelper.release(buffer);
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);){
            Object object;
            try (DataInputStream stream = new DataInputStream(byteStream);){
                object = SpongeReflectionUtil.readNmsNbtFromStream(stream);
            }
            return object;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeNmsNbtToStream(Object compound, DataOutput out) {
        try {
            WRITE_NBT_TO_STREAM_METHOD.invoke(null, compound, out);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Object readNmsNbtFromStream(DataInputStream in) {
        try {
            return READ_NBT_FROM_STREAM_METHOD.invoke(null, in);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

