/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.impl.sponge.util.viaversion;

import forcepack.libs.pe.api.protocol.player.User;
import forcepack.libs.pe.impl.sponge.util.viaversion.ViaState;
import forcepack.libs.pe.impl.sponge.util.viaversion.ViaVersionAccessor;
import forcepack.libs.pe.impl.sponge.util.viaversion.ViaVersionAccessorImpl;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;

public class ViaVersionUtil {
    private static ViaState available = ViaState.UNKNOWN;
    private static ViaVersionAccessor viaVersionAccessor;

    private ViaVersionUtil() {
    }

    private static void load() {
        if (viaVersionAccessor == null) {
            try {
                Class.forName("com.viaversion.viaversion.api.Via");
                viaVersionAccessor = new ViaVersionAccessorImpl();
            }
            catch (Exception e) {
                viaVersionAccessor = null;
            }
        }
    }

    public static void checkIfViaIsPresent() {
        boolean present = Sponge.pluginManager().plugin("viaversion").isPresent();
        available = present ? ViaState.ENABLED : ViaState.DISABLED;
    }

    public static boolean isAvailable() {
        if (available == ViaState.UNKNOWN) {
            return ViaVersionUtil.getViaVersionAccessor() != null;
        }
        return available == ViaState.ENABLED;
    }

    public static ViaVersionAccessor getViaVersionAccessor() {
        ViaVersionUtil.load();
        return viaVersionAccessor;
    }

    public static int getProtocolVersion(User user) {
        return ViaVersionUtil.getViaVersionAccessor().getProtocolVersion(user);
    }

    public static int getProtocolVersion(ServerPlayer player) {
        return ViaVersionUtil.getViaVersionAccessor().getProtocolVersion(player);
    }

    public static Class<?> getUserConnectionClass() {
        return ViaVersionUtil.getViaVersionAccessor().getUserConnectionClass();
    }

    public static Class<?> getSpongeDecodeHandlerClass() {
        return ViaVersionUtil.getViaVersionAccessor().getSpongeDecodeHandlerClass();
    }

    public static Class<?> getSpongeEncodeHandlerClass() {
        return ViaVersionUtil.getViaVersionAccessor().getSpongeEncodeHandlerClass();
    }
}

