/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.sponge.cloud.annotations.extractor;

import forcepack.libs.sponge.cloud.annotations.AnnotationParser;
import forcepack.libs.sponge.cloud.annotations.Argument;
import forcepack.libs.sponge.cloud.annotations.ArgumentMode;
import forcepack.libs.sponge.cloud.annotations.Default;
import forcepack.libs.sponge.cloud.annotations.DefaultValueFactory;
import forcepack.libs.sponge.cloud.annotations.DescriptionMapper;
import forcepack.libs.sponge.cloud.annotations.SyntaxFragment;
import forcepack.libs.sponge.cloud.annotations.descriptor.ArgumentDescriptor;
import forcepack.libs.sponge.cloud.annotations.descriptor.ImmutableArgumentDescriptor;
import forcepack.libs.sponge.cloud.annotations.extractor.ArgumentExtractor;
import forcepack.libs.sponge.cloud.annotations.extractor.ImmutableStandardArgumentExtractor;
import forcepack.libs.sponge.cloud.annotations.extractor.ParameterNameExtractor;
import forcepack.libs.sponge.cloud.component.DefaultValue;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

@Value.Immutable
public abstract class StandardArgumentExtractor
implements ArgumentExtractor {
    private static @Nullable String nullIfEmpty(@NonNull String string) {
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    public static @NonNull StandardArgumentExtractor create(@NonNull AnnotationParser<?> annotationParser) {
        return StandardArgumentExtractor.builder(annotationParser).build();
    }

    public static @NonNull ImmutableStandardArgumentExtractor.Builder builder(@NonNull AnnotationParser<?> annotationParser) {
        return ImmutableStandardArgumentExtractor.builder().annotationParser(annotationParser);
    }

    public static @NonNull ImmutableStandardArgumentExtractor.Builder builder(@NonNull StandardArgumentExtractor extractor) {
        return ImmutableStandardArgumentExtractor.builder().from(extractor);
    }

    public abstract @NonNull AnnotationParser<?> annotationParser();

    @Value.Default
    public @NonNull ParameterNameExtractor parameterNameExtractor() {
        return ParameterNameExtractor.simple();
    }

    @Value.Default
    public @NonNull DescriptionMapper descriptionMapper() {
        return this.annotationParser()::mapDescription;
    }

    @Override
    public final @NonNull Collection<@NonNull ArgumentDescriptor> extractArguments(@NonNull List<@NonNull SyntaxFragment> syntax, @NonNull Method method) {
        HashMap variableFragments = new HashMap();
        syntax.stream().filter(fragment -> fragment.argumentMode() != ArgumentMode.LITERAL).forEach(fragment -> variableFragments.put(fragment.major(), fragment));
        ArrayList<ArgumentDescriptor> arguments = new ArrayList<ArgumentDescriptor>();
        for (Parameter parameter : method.getParameters()) {
            String parameterName = this.parameterNameExtractor().extract(parameter);
            DefaultValue<Object, Object> defaultValue = null;
            if (parameter.isAnnotationPresent(Default.class)) {
                Default defaultAnnotation = parameter.getAnnotation(Default.class);
                if (defaultAnnotation.name().isEmpty()) {
                    defaultValue = DefaultValue.parsed(this.annotationParser().processString(parameter.getAnnotation(Default.class).value()));
                } else {
                    DefaultValueFactory<?, ?> factory = this.annotationParser().defaultValueRegistry().named(this.annotationParser().processString(defaultAnnotation.name())).orElseThrow(() -> new IllegalArgumentException(String.format("No default value factory named '%s' has been registered", defaultAnnotation.name())));
                    defaultValue = factory.create(parameter);
                }
            }
            if (!parameter.isAnnotationPresent(Argument.class)) {
                SyntaxFragment fragment2 = (SyntaxFragment)variableFragments.get(parameterName);
                if (fragment2 == null) continue;
                arguments.add(ArgumentDescriptor.builder().parameter(parameter).defaultValue(defaultValue).name(parameterName).build());
                continue;
            }
            Argument argument = parameter.getAnnotation(Argument.class);
            String name = argument.value().equals("__INFERRED_ARGUMENT_NAME__") ? parameterName : this.annotationParser().processString(argument.value());
            ImmutableArgumentDescriptor argumentDescriptor = ArgumentDescriptor.builder().parameter(parameter).name(name).parserName(StandardArgumentExtractor.nullIfEmpty(this.annotationParser().processString(argument.parserName()))).defaultValue(defaultValue).description(this.descriptionMapper().map(argument.description())).suggestions(StandardArgumentExtractor.nullIfEmpty(this.annotationParser().processString(argument.suggestions()))).build();
            arguments.add(argumentDescriptor);
        }
        return arguments;
    }
}

