/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.sponge.cloud.minecraft.modded.internal;

import com.mojang.brigadier.arguments.ArgumentType;
import forcepack.libs.sponge.cloud.CommandManager;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL, consumers={"forcepack.libs.sponge.cloud.*"})
public final class ContextualArgumentTypeProvider<V>
implements Supplier<ArgumentType<V>> {
    private static final ThreadLocal<ThreadLocalContext> CONTEXT = new ThreadLocal();
    private static final Map<CommandManager<?>, Set<ContextualArgumentTypeProvider<?>>> INSTANCES = new WeakHashMap();
    private final Function<CommandBuildContext, ArgumentType<V>> provider;
    private volatile ArgumentType<V> provided;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withBuildContext(CommandManager<?> commandManager, CommandBuildContext ctx, boolean resetExisting, Runnable action) {
        ThreadLocalContext context = new ThreadLocalContext(commandManager, ctx);
        CONTEXT.set(context);
        try {
            if (resetExisting) {
                Map<CommandManager<?>, Set<ContextualArgumentTypeProvider<?>>> map = INSTANCES;
                synchronized (map) {
                    for (ContextualArgumentTypeProvider<?> contextualArgumentTypeProvider : context.instances()) {
                        contextualArgumentTypeProvider.provided = null;
                    }
                }
            }
            action.run();
        }
        finally {
            CONTEXT.remove();
        }
    }

    public ContextualArgumentTypeProvider(@NonNull Function<CommandBuildContext, ArgumentType<V>> provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArgumentType<V> get() {
        ArgumentType<V> provided;
        ThreadLocalContext ctx = CONTEXT.get();
        if (ctx != null) {
            Map<CommandManager<?>, Set<ContextualArgumentTypeProvider<?>>> map = INSTANCES;
            synchronized (map) {
                ctx.instances().add(this);
            }
        }
        if ((provided = this.provided) == null) {
            ContextualArgumentTypeProvider contextualArgumentTypeProvider = this;
            synchronized (contextualArgumentTypeProvider) {
                if (this.provided == null) {
                    if (ctx == null) {
                        throw new IllegalStateException("No build context was available while trying to compute an argument type");
                    }
                    this.provided = provided = this.provider.apply(ctx.commandBuildContext);
                }
            }
        }
        return provided;
    }

    private record ThreadLocalContext(CommandManager<?> commandManager, CommandBuildContext commandBuildContext) {
        private Set<ContextualArgumentTypeProvider<?>> instances() {
            return INSTANCES.computeIfAbsent(this.commandManager, $ -> Collections.newSetFromMap(new WeakHashMap()));
        }
    }
}

