/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.sponge.cloud.sponge;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import forcepack.libs.sponge.cloud.CommandManager;
import forcepack.libs.sponge.cloud.SenderMapper;
import forcepack.libs.sponge.cloud.SenderMapperHolder;
import forcepack.libs.sponge.cloud.execution.ExecutionCoordinator;
import forcepack.libs.sponge.cloud.meta.CommandMeta;
import forcepack.libs.sponge.cloud.meta.SimpleCommandMeta;
import forcepack.libs.sponge.cloud.parser.ParserParameters;
import forcepack.libs.sponge.cloud.sponge.SpongeCommandPreprocessor;
import forcepack.libs.sponge.cloud.sponge.SpongeDefaultCaptionsProvider;
import forcepack.libs.sponge.cloud.sponge.SpongeDefaultExceptionHandlers;
import forcepack.libs.sponge.cloud.sponge.SpongeParserMapper;
import forcepack.libs.sponge.cloud.sponge.SpongeParserParameters;
import forcepack.libs.sponge.cloud.sponge.SpongeRegistrationHandler;
import forcepack.libs.sponge.cloud.sponge.annotation.specifier.Center;
import forcepack.libs.sponge.cloud.sponge.parser.BlockInputParser;
import forcepack.libs.sponge.cloud.sponge.parser.BlockPredicateParser;
import forcepack.libs.sponge.cloud.sponge.parser.ComponentParser;
import forcepack.libs.sponge.cloud.sponge.parser.DataContainerParser;
import forcepack.libs.sponge.cloud.sponge.parser.GameProfileCollectionParser;
import forcepack.libs.sponge.cloud.sponge.parser.GameProfileParser;
import forcepack.libs.sponge.cloud.sponge.parser.ItemStackPredicateParser;
import forcepack.libs.sponge.cloud.sponge.parser.MultipleEntitySelectorParser;
import forcepack.libs.sponge.cloud.sponge.parser.MultiplePlayerSelectorParser;
import forcepack.libs.sponge.cloud.sponge.parser.NamedTextColorParser;
import forcepack.libs.sponge.cloud.sponge.parser.OperatorParser;
import forcepack.libs.sponge.cloud.sponge.parser.ProtoItemStackParser;
import forcepack.libs.sponge.cloud.sponge.parser.RegistryEntryParser;
import forcepack.libs.sponge.cloud.sponge.parser.ResourceKeyParser;
import forcepack.libs.sponge.cloud.sponge.parser.SingleEntitySelectorParser;
import forcepack.libs.sponge.cloud.sponge.parser.SinglePlayerSelectorParser;
import forcepack.libs.sponge.cloud.sponge.parser.UserParser;
import forcepack.libs.sponge.cloud.sponge.parser.Vector2dParser;
import forcepack.libs.sponge.cloud.sponge.parser.Vector2iParser;
import forcepack.libs.sponge.cloud.sponge.parser.Vector3dParser;
import forcepack.libs.sponge.cloud.sponge.parser.Vector3iParser;
import forcepack.libs.sponge.cloud.sponge.parser.WorldParser;
import forcepack.libs.sponge.cloud.sponge.suggestion.SpongeSuggestion;
import forcepack.libs.sponge.cloud.state.RegistrationState;
import forcepack.libs.sponge.cloud.suggestion.SuggestionFactory;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.registry.DefaultedRegistryType;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.math.vector.Vector2d;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeCommandManager<C>
extends CommandManager<C>
implements SenderMapperHolder<CommandCause, C> {
    private final PluginContainer pluginContainer;
    private final SenderMapper<CommandCause, C> senderMapper;
    private final SpongeParserMapper<C> parserMapper;
    private final SuggestionFactory<C, SpongeSuggestion> suggestionFactory;
    private final Set<Consumer<SpongeCommandManager<C>>> registrationCallbackListeners = new HashSet<Consumer<SpongeCommandManager<C>>>();

    @Inject
    public SpongeCommandManager(@NonNull PluginContainer pluginContainer, @NonNull ExecutionCoordinator<C> executionCoordinator, @NonNull RegistryHolder registryHolder, @NonNull SenderMapper<CommandCause, C> senderMapper) {
        super(executionCoordinator, new SpongeRegistrationHandler());
        this.checkLateCreation();
        this.pluginContainer = pluginContainer;
        ((SpongeRegistrationHandler)this.commandRegistrationHandler()).initialize(this);
        this.senderMapper = senderMapper;
        this.parserMapper = new SpongeParserMapper(registryHolder);
        this.registerCommandPreProcessor(new SpongeCommandPreprocessor(this));
        this.registerParsers();
        this.captionRegistry().registerProvider(new SpongeDefaultCaptionsProvider());
        this.suggestionFactory = super.suggestionFactory().mapped(SpongeSuggestion::spongeSuggestion);
        SpongeDefaultExceptionHandlers.register(this);
    }

    @Override
    public @NonNull SuggestionFactory<C, SpongeSuggestion> suggestionFactory() {
        return this.suggestionFactory;
    }

    private void checkLateCreation() {
        if (!Sponge.isServerAvailable()) {
            return;
        }
        throw new IllegalStateException("SpongeCommandManager must be created before the first firing of RegisterCommandEvent. (created too late)");
    }

    private void registerParsers() {
        this.parserRegistry().registerParser(ComponentParser.componentParser()).registerParser(NamedTextColorParser.namedTextColorParser()).registerParser(OperatorParser.operatorParser()).registerParser(WorldParser.worldParser()).registerParser(ProtoItemStackParser.protoItemStackParser()).registerParser(ItemStackPredicateParser.itemStackPredicateParser()).registerParser(ResourceKeyParser.resourceKeyParser()).registerParser(GameProfileParser.gameProfileParser()).registerParser(GameProfileCollectionParser.gameProfileCollectionParser()).registerParser(BlockInputParser.blockInputParser()).registerParser(BlockPredicateParser.blockPredicateParser()).registerParser(UserParser.userParser()).registerParser(DataContainerParser.dataContainerParser()).registerAnnotationMapper(Center.class, (annotation, type) -> ParserParameters.single(SpongeParserParameters.CENTER_INTEGERS, true)).registerParserSupplier(TypeToken.get(Vector2d.class), params -> new Vector2dParser(params.get(SpongeParserParameters.CENTER_INTEGERS, false))).registerParserSupplier(TypeToken.get(Vector3d.class), params -> new Vector3dParser(params.get(SpongeParserParameters.CENTER_INTEGERS, false))).registerParser(Vector2iParser.vector2iParser()).registerParser(Vector3iParser.vector3iParser()).registerParser(SinglePlayerSelectorParser.singlePlayerSelectorParser()).registerParser(MultiplePlayerSelectorParser.multiplePlayerSelectorParser()).registerParser(SingleEntitySelectorParser.singleEntitySelectorParser()).registerParser(MultipleEntitySelectorParser.multipleEntitySelectorParser());
        this.registerRegistryParsers();
    }

    private void registerRegistryParsers() {
        ImmutableSet ignoredRegistryTypes = ImmutableSet.of((Object)RegistryTypes.OPERATOR);
        for (Field field : RegistryTypes.class.getDeclaredFields()) {
            RegistryType registryType;
            Type generic = field.getGenericType();
            if (!(generic instanceof ParameterizedType)) continue;
            try {
                registryType = (RegistryType)field.get(null);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Failed to access RegistryTypes." + field.getName(), ex);
            }
            if (ignoredRegistryTypes.contains(registryType) || !(registryType instanceof DefaultedRegistryType)) continue;
            DefaultedRegistryType defaultedRegistryType = (DefaultedRegistryType)registryType;
            Type valueType = ((ParameterizedType)generic).getActualTypeArguments()[0];
            this.parserRegistry().registerParserSupplier(TypeToken.get((Type)valueType), params -> new RegistryEntryParser(defaultedRegistryType));
        }
    }

    @Override
    public boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        if (permission.isEmpty()) {
            return true;
        }
        return this.senderMapper.reverse(sender).hasPermission(permission);
    }

    @Override
    public @NonNull CommandMeta createDefaultCommandMeta() {
        return SimpleCommandMeta.empty();
    }

    public @NonNull PluginContainer owningPluginContainer() {
        return this.pluginContainer;
    }

    public @NonNull SpongeParserMapper<C> parserMapper() {
        return this.parserMapper;
    }

    @Override
    public @NonNull SenderMapper<CommandCause, C> senderMapper() {
        return this.senderMapper;
    }

    void registrationCalled() {
        if (!this.registrationCallbackListeners.isEmpty()) {
            this.registrationCallbackListeners.forEach(listener -> listener.accept(this));
            this.registrationCallbackListeners.clear();
        }
        if (this.state() != RegistrationState.AFTER_REGISTRATION) {
            this.lockRegistration();
        }
    }

    public void addRegistrationCallbackListener(@NonNull Consumer<@NonNull SpongeCommandManager<C>> listener) {
        if (this.state() == RegistrationState.AFTER_REGISTRATION) {
            throw new IllegalStateException("The SpongeCommandManager is in the AFTER_REGISTRATION state!");
        }
        this.registrationCallbackListeners.add(listener);
    }
}

