/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.sponge.cloud.sponge.parser;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forcepack.libs.sponge.cloud.brigadier.parser.WrappedBrigadierParser;
import forcepack.libs.sponge.cloud.context.CommandContext;
import forcepack.libs.sponge.cloud.context.CommandInput;
import forcepack.libs.sponge.cloud.parser.ArgumentParseResult;
import forcepack.libs.sponge.cloud.parser.ArgumentParser;
import forcepack.libs.sponge.cloud.parser.ParserDescriptor;
import forcepack.libs.sponge.cloud.sponge.NodeSource;
import forcepack.libs.sponge.cloud.sponge.SpongeCommandContextKeys;
import forcepack.libs.sponge.cloud.sponge.data.GameProfileCollection;
import forcepack.libs.sponge.cloud.suggestion.Suggestion;
import forcepack.libs.sponge.cloud.suggestion.SuggestionProvider;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeType;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeTypes;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.common.profile.SpongeGameProfile;

public final class GameProfileCollectionParser<C>
implements NodeSource,
ArgumentParser.FutureArgumentParser<C, GameProfileCollection>,
SuggestionProvider<C> {
    private final ArgumentParser<C, GameProfileCollection> mappedParser = new WrappedBrigadierParser((ArgumentType<GameProfileArgument.Result>)GameProfileArgument.gameProfile()).flatMapSuccess((ctx, argumentResult) -> {
        Collection profiles;
        try {
            profiles = argumentResult.getNames((CommandSourceStack)ctx.get(SpongeCommandContextKeys.COMMAND_CAUSE));
        }
        catch (CommandSyntaxException ex) {
            return ArgumentParseResult.failureFuture(ex);
        }
        List result = profiles.stream().map(SpongeGameProfile::of).collect(Collectors.toList());
        return ArgumentParseResult.successFuture(new GameProfileCollectionImpl(Collections.unmodifiableCollection(result)));
    });

    public static <C> ParserDescriptor<C, GameProfileCollection> gameProfileCollectionParser() {
        return ParserDescriptor.of(new GameProfileCollectionParser<C>(), GameProfileCollection.class);
    }

    @Override
    public @NonNull CompletableFuture<ArgumentParseResult<@NonNull GameProfileCollection>> parseFuture(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput inputQueue) {
        return this.mappedParser.parseFuture(commandContext, inputQueue);
    }

    @Override
    public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> context, @NonNull CommandInput input) {
        return this.mappedParser.suggestionProvider().suggestionsFuture(context, input);
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandTreeNode.Argument<? extends // Could not load outer class - annotation placement on inner may be incorrect
    CommandTreeNode.Argument<?>> node(RegistryHolder registryHolder) {
        return (CommandTreeNode.Argument)((CommandTreeNodeType)CommandTreeNodeTypes.GAME_PROFILE.get(new RegistryHolder[]{registryHolder})).createNode();
    }

    private static final class GameProfileCollectionImpl
    extends AbstractCollection<GameProfile>
    implements GameProfileCollection {
        private final Collection<GameProfile> backing;

        private GameProfileCollectionImpl(Collection<GameProfile> backing) {
            this.backing = backing;
        }

        @Override
        public int size() {
            return this.backing.size();
        }

        @Override
        public Iterator<GameProfile> iterator() {
            return this.backing.iterator();
        }

        @Override
        public boolean add(GameProfile gameProfile) {
            return this.backing.add(gameProfile);
        }
    }
}

