/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.sponge.cloud.sponge.parser;

import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import forcepack.libs.sponge.cloud.context.CommandContext;
import forcepack.libs.sponge.cloud.context.CommandInput;
import forcepack.libs.sponge.cloud.parser.ArgumentParseResult;
import forcepack.libs.sponge.cloud.parser.ArgumentParser;
import forcepack.libs.sponge.cloud.parser.ParserDescriptor;
import forcepack.libs.sponge.cloud.sponge.NodeSource;
import forcepack.libs.sponge.cloud.suggestion.BlockingSuggestionProvider;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.parameter.managed.operator.Operator;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeType;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeTypes;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryTypes;

public final class OperatorParser<C>
implements NodeSource,
ArgumentParser<C, Operator>,
BlockingSuggestionProvider.Strings<C> {
    private static final SimpleCommandExceptionType ERROR_INVALID_OPERATION;

    public static <C> ParserDescriptor<C, Operator> operatorParser() {
        return ParserDescriptor.of(new OperatorParser<C>(), Operator.class);
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull Operator> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput inputQueue) {
        String input = inputQueue.readString();
        Optional<Operator> operator = RegistryTypes.OPERATOR.get().stream().filter(op -> op.asString().equals(input)).findFirst();
        if (!operator.isPresent()) {
            return ArgumentParseResult.failure(ERROR_INVALID_OPERATION.create());
        }
        return ArgumentParseResult.success(operator.get());
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return RegistryTypes.OPERATOR.get().stream().map(Operator::asString).collect(Collectors.toList());
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandTreeNode.Argument<? extends // Could not load outer class - annotation placement on inner may be incorrect
    CommandTreeNode.Argument<?>> node(RegistryHolder registryHolder) {
        return (CommandTreeNode.Argument)((CommandTreeNodeType)CommandTreeNodeTypes.OPERATION.get(new RegistryHolder[]{registryHolder})).createNode();
    }

    static {
        try {
            Class<?> spongeAccessor = Class.forName("org.spongepowered.common.accessor.commands.arguments.OperationArgumentAccessor");
            Method get = spongeAccessor.getDeclaredMethod("accessor$ERROR_INVALID_OPERATION", new Class[0]);
            get.setAccessible(true);
            ERROR_INVALID_OPERATION = (SimpleCommandExceptionType)get.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException("Couldn't access ERROR_INVALID_OPERATION command exception type.", ex);
        }
    }
}

