/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.sponge.cloud.sponge.parser;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forcepack.libs.sponge.cloud.brigadier.parser.WrappedBrigadierParser;
import forcepack.libs.sponge.cloud.context.CommandContext;
import forcepack.libs.sponge.cloud.context.CommandInput;
import forcepack.libs.sponge.cloud.minecraft.modded.internal.ContextualArgumentTypeProvider;
import forcepack.libs.sponge.cloud.parser.ArgumentParseResult;
import forcepack.libs.sponge.cloud.parser.ArgumentParser;
import forcepack.libs.sponge.cloud.parser.ParserDescriptor;
import forcepack.libs.sponge.cloud.sponge.NodeSource;
import forcepack.libs.sponge.cloud.sponge.data.ProtoItemStack;
import forcepack.libs.sponge.cloud.sponge.exception.ComponentMessageRuntimeException;
import forcepack.libs.sponge.cloud.suggestion.Suggestion;
import forcepack.libs.sponge.cloud.suggestion.SuggestionProvider;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.util.ComponentMessageThrowable;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.nbt.CompoundTag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeType;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeTypes;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.common.data.persistence.NBTTranslator;

public final class ProtoItemStackParser<C>
implements NodeSource,
ArgumentParser.FutureArgumentParser<C, ProtoItemStack>,
SuggestionProvider<C> {
    private final ArgumentParser<C, ProtoItemStack> mappedParser = new WrappedBrigadierParser(new ContextualArgumentTypeProvider(ItemArgument::item)).flatMapSuccess((ctx, itemInput) -> ArgumentParseResult.successFuture(new ProtoItemStackImpl((ItemInput)itemInput)));

    public static <C> ParserDescriptor<C, ProtoItemStack> protoItemStackParser() {
        return ParserDescriptor.of(new ProtoItemStackParser<C>(), ProtoItemStack.class);
    }

    @Override
    public @NonNull CompletableFuture<ArgumentParseResult<@NonNull ProtoItemStack>> parseFuture(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput inputQueue) {
        return this.mappedParser.parseFuture(commandContext, inputQueue);
    }

    @Override
    public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> context, @NonNull CommandInput input) {
        return this.mappedParser.suggestionProvider().suggestionsFuture(context, input);
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandTreeNode.Argument<? extends // Could not load outer class - annotation placement on inner may be incorrect
    CommandTreeNode.Argument<?>> node(RegistryHolder registryHolder) {
        return (CommandTreeNode.Argument)((CommandTreeNodeType)CommandTreeNodeTypes.ITEM_STACK.get(new RegistryHolder[]{registryHolder})).createNode();
    }

    private static final class ProtoItemStackImpl
    implements ProtoItemStack {
        private static final Field COMPOUND_TAG_FIELD = Arrays.stream(ItemInput.class.getDeclaredFields()).filter(f -> f.getType().equals(CompoundTag.class)).findFirst().orElseThrow(IllegalStateException::new);
        private final ItemInput itemInput;
        private final @Nullable DataContainer extraData;

        ProtoItemStackImpl(@NonNull ItemInput itemInput) {
            this.itemInput = itemInput;
            try {
                CompoundTag tag = (CompoundTag)COMPOUND_TAG_FIELD.get(itemInput);
                this.extraData = tag == null ? null : NBTTranslator.INSTANCE.translate(tag);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public @NonNull ItemType itemType() {
            return (ItemType)this.itemInput.getItem();
        }

        @Override
        public @Nullable DataContainer extraData() {
            return this.extraData;
        }

        @Override
        public @NonNull ItemStack createItemStack(int stackSize, boolean respectMaximumStackSize) throws ComponentMessageRuntimeException {
            try {
                return (ItemStack)this.itemInput.createItemStack(stackSize, respectMaximumStackSize);
            }
            catch (CommandSyntaxException ex) {
                throw new ComponentMessageRuntimeException((ComponentLike)ComponentMessageThrowable.getMessage((Throwable)ex), (Throwable)ex);
            }
        }

        @Override
        public @NonNull ItemStackSnapshot createItemStackSnapshot(int stackSize, boolean respectMaximumStackSize) throws ComponentMessageRuntimeException {
            return this.createItemStack(stackSize, respectMaximumStackSize).asImmutable();
        }

        static {
            COMPOUND_TAG_FIELD.setAccessible(true);
        }
    }
}

