/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.sponge.cloud.sponge.parser;

import forcepack.libs.sponge.cloud.caption.CaptionVariable;
import forcepack.libs.sponge.cloud.context.CommandContext;
import forcepack.libs.sponge.cloud.context.CommandInput;
import forcepack.libs.sponge.cloud.exception.parsing.ParserException;
import forcepack.libs.sponge.cloud.parser.ArgumentParseResult;
import forcepack.libs.sponge.cloud.parser.ArgumentParser;
import forcepack.libs.sponge.cloud.parser.ParserDescriptor;
import forcepack.libs.sponge.cloud.sponge.NodeSource;
import forcepack.libs.sponge.cloud.sponge.SpongeCaptionKeys;
import forcepack.libs.sponge.cloud.sponge.parser.ResourceKeyParser;
import forcepack.libs.sponge.cloud.suggestion.BlockingSuggestionProvider;
import io.leangen.geantyref.TypeToken;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.registrar.tree.CommandCompletionProviders;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeType;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeTypes;
import org.spongepowered.api.registry.DefaultedRegistryType;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;

public final class RegistryEntryParser<C, V>
implements NodeSource,
ArgumentParser.FutureArgumentParser<C, V>,
BlockingSuggestionProvider.Strings<C> {
    private static final ArgumentParser<?, ResourceKey> RESOURCE_KEY_PARSER = new ResourceKeyParser();
    private final Function<CommandContext<C>, RegistryHolder> holderSupplier;
    private final RegistryType<V> registryType;

    public static <C, V> @NonNull ParserDescriptor<C, V> registryEntryParser(@NonNull TypeToken<V> valueType, @NonNull DefaultedRegistryType<V> registryType) {
        return ParserDescriptor.of(new RegistryEntryParser<C, V>(registryType), valueType);
    }

    public static <C, V> @NonNull ParserDescriptor<C, V> registryEntryParser(@NonNull Class<V> valueType, @NonNull DefaultedRegistryType<V> registryType) {
        return ParserDescriptor.of(new RegistryEntryParser<C, V>(registryType), valueType);
    }

    public static <C, V> @NonNull ParserDescriptor<C, V> registryEntryParser(@NonNull Class<V> valueType, @NonNull RegistryType<V> registryType, @NonNull Function<CommandContext<C>, RegistryHolder> holderSupplier) {
        return ParserDescriptor.of(new RegistryEntryParser<C, V>(holderSupplier, registryType), valueType);
    }

    public static <C, V> @NonNull ParserDescriptor<C, V> registryEntryParser(@NonNull TypeToken<V> valueType, @NonNull RegistryType<V> registryType, @NonNull Function<CommandContext<C>, RegistryHolder> holderSupplier) {
        return ParserDescriptor.of(new RegistryEntryParser<C, V>(holderSupplier, registryType), valueType);
    }

    public RegistryEntryParser(@NonNull Function<CommandContext<C>, RegistryHolder> holderSupplier, @NonNull RegistryType<V> registryType) {
        this.holderSupplier = holderSupplier;
        this.registryType = registryType;
    }

    public RegistryEntryParser(@NonNull DefaultedRegistryType<V> registryType) {
        this(ctx -> (RegistryHolder)registryType.defaultHolder().get(), (RegistryType<V>)registryType);
    }

    private Registry<V> registry(@NonNull CommandContext<C> commandContext) {
        return this.holderSupplier.apply(commandContext).registry(this.registryType);
    }

    @Override
    public @NonNull CompletableFuture<@NonNull ArgumentParseResult<@NonNull V>> parseFuture(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput inputQueue) {
        return RESOURCE_KEY_PARSER.parseFuture(commandContext, inputQueue).thenApply(keyResult -> {
            if (keyResult.failure().isPresent()) {
                return ArgumentParseResult.failure(keyResult.failure().get());
            }
            Optional entry = this.registry(commandContext).findEntry((ResourceKey)keyResult.parsedValue().get());
            if (entry.isPresent()) {
                return ArgumentParseResult.success(((RegistryEntry)entry.get()).value());
            }
            return ArgumentParseResult.failure(new NoSuchEntryException(commandContext, (ResourceKey)keyResult.parsedValue().get(), this.registryType));
        });
    }

    public @NonNull List<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return this.registry(commandContext).streamEntries().flatMap((? super T entry) -> {
            if (!input.isEmpty() && entry.key().namespace().equals("minecraft")) {
                return Stream.of(entry.key().value(), entry.key().asString());
            }
            return Stream.of(entry.key().asString());
        }).collect(Collectors.toList());
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandTreeNode.Argument<? extends // Could not load outer class - annotation placement on inner may be incorrect
    CommandTreeNode.Argument<?>> node(RegistryHolder registryHolder) {
        if (this.registryType.equals((Object)RegistryTypes.SOUND_TYPE)) {
            return (CommandTreeNode.Argument)((CommandTreeNode.Basic)((CommandTreeNodeType)CommandTreeNodeTypes.RESOURCE_LOCATION.get(new RegistryHolder[]{registryHolder})).createNode()).completions(CommandCompletionProviders.AVAILABLE_SOUNDS);
        }
        if (this.registryType.equals((Object)RegistryTypes.ENTITY_TYPE)) {
            return (CommandTreeNode.Argument)((CommandTreeNode.Basic)((CommandTreeNodeType)CommandTreeNodeTypes.RESOURCE_LOCATION.get(new RegistryHolder[]{registryHolder})).createNode()).completions(CommandCompletionProviders.SUMMONABLE_ENTITIES);
        }
        if (this.registryType.equals((Object)RegistryTypes.WORLD_TYPE)) {
            return (CommandTreeNode.Argument)((CommandTreeNode.Basic)((CommandTreeNodeType)CommandTreeNodeTypes.DIMENSION.get(new RegistryHolder[]{registryHolder})).createNode()).customCompletions();
        }
        return (CommandTreeNode.Argument)((CommandTreeNode.Basic)((CommandTreeNodeType)CommandTreeNodeTypes.RESOURCE_LOCATION.get(new RegistryHolder[]{registryHolder})).createNode()).customCompletions();
    }

    private static final class NoSuchEntryException
    extends ParserException {
        private static final long serialVersionUID = 4472876671109079272L;

        NoSuchEntryException(CommandContext<?> context, ResourceKey key, RegistryType<?> registryType) {
            super(RegistryEntryParser.class, context, SpongeCaptionKeys.ARGUMENT_PARSE_FAILURE_REGISTRY_ENTRY_UNKNOWN_ENTRY, CaptionVariable.of("id", key.asString()), CaptionVariable.of("registry", registryType.location().asString()));
        }
    }
}

