/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.sponge.cloud.sponge.parser;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forcepack.libs.sponge.cloud.brigadier.parser.WrappedBrigadierParser;
import forcepack.libs.sponge.cloud.caption.Caption;
import forcepack.libs.sponge.cloud.caption.CaptionVariable;
import forcepack.libs.sponge.cloud.context.CommandContext;
import forcepack.libs.sponge.cloud.context.CommandInput;
import forcepack.libs.sponge.cloud.exception.parsing.ParserException;
import forcepack.libs.sponge.cloud.parser.ArgumentParseResult;
import forcepack.libs.sponge.cloud.parser.ArgumentParser;
import forcepack.libs.sponge.cloud.parser.ParserDescriptor;
import forcepack.libs.sponge.cloud.sponge.NodeSource;
import forcepack.libs.sponge.cloud.sponge.SpongeCaptionKeys;
import forcepack.libs.sponge.cloud.sponge.SpongeCommandContextKeys;
import forcepack.libs.sponge.cloud.suggestion.Suggestion;
import forcepack.libs.sponge.cloud.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeType;
import org.spongepowered.api.command.registrar.tree.CommandTreeNodeTypes;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.registry.RegistryHolder;

public final class UserParser<C>
implements NodeSource,
ArgumentParser<C, UUID>,
SuggestionProvider<C> {
    private final ArgumentParser<C, EntitySelector> singlePlayerSelectorParser = new WrappedBrigadierParser<C, EntitySelector>((ArgumentType<EntitySelector>)EntityArgument.player());

    public static <C> ParserDescriptor<C, UUID> userParser() {
        return ParserDescriptor.of(new UserParser<C>(), UUID.class);
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull UUID> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput inputQueue) {
        CommandInput inputCopy = inputQueue.copy();
        String peek = inputQueue.readString();
        if (peek.startsWith("@")) {
            return this.handleSelector(commandContext, inputCopy);
        }
        try {
            Optional optionalUser = Sponge.server().gameProfileManager().cache().findByName(peek);
            if (optionalUser.isPresent()) {
                return ArgumentParseResult.success(((GameProfile)optionalUser.get()).uniqueId());
            }
            return ArgumentParseResult.failure(new UserNotFoundException(commandContext, UserNotFoundException.Type.NAME, peek));
        }
        catch (IllegalArgumentException optionalUser) {
            try {
                UUID uuid = UUID.fromString(peek);
                if (Sponge.server().userManager().exists(uuid)) {
                    return ArgumentParseResult.success(uuid);
                }
                return ArgumentParseResult.failure(new UserNotFoundException(commandContext, UserNotFoundException.Type.UUID, peek));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return ArgumentParseResult.failure(new UserNotFoundException(commandContext, UserNotFoundException.Type.INVALID_INPUT, peek));
            }
        }
    }

    private @NonNull ArgumentParseResult<@NonNull UUID> handleSelector(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput inputQueue) {
        ServerPlayer player;
        ArgumentParseResult<EntitySelector> result = this.singlePlayerSelectorParser.parse(commandContext, inputQueue);
        if (result.failure().isPresent()) {
            return ArgumentParseResult.failure(result.failure().get());
        }
        EntitySelector parsed = result.parsedValue().get();
        try {
            player = (ServerPlayer)parsed.findSinglePlayer((CommandSourceStack)commandContext.get(SpongeCommandContextKeys.COMMAND_CAUSE));
        }
        catch (CommandSyntaxException ex) {
            return ArgumentParseResult.failure(ex);
        }
        return ArgumentParseResult.success(player.uniqueId());
    }

    @Override
    public @NonNull CompletableFuture<Iterable<@NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return this.singlePlayerSelectorParser.suggestionProvider().suggestionsFuture(commandContext, input).thenApply(it -> {
            ArrayList suggestions = new ArrayList();
            it.forEach(suggestions::add);
            String peek = input.peekString();
            if (!peek.startsWith("@")) {
                suggestions.addAll(Sponge.server().userManager().streamOfMatches(peek).filter(GameProfile::hasName).map(profile -> profile.name().orElse(null)).filter(Objects::nonNull).filter(name -> suggestions.stream().noneMatch(s -> s.suggestion().equals(name))).map(Suggestion::suggestion).collect(Collectors.toList()));
            }
            return suggestions;
        });
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandTreeNode.Argument<? extends // Could not load outer class - annotation placement on inner may be incorrect
    CommandTreeNode.Argument<?>> node(RegistryHolder registryHolder) {
        return (CommandTreeNode.Argument)((CommandTreeNode.Basic)((CommandTreeNodeType)CommandTreeNodeTypes.GAME_PROFILE.get(new RegistryHolder[]{registryHolder})).createNode()).customCompletions();
    }

    private static final class UserNotFoundException
    extends ParserException {
        private static final long serialVersionUID = -24501459406523175L;

        UserNotFoundException(CommandContext<?> context, @NonNull Type type, @NonNull String input) {
            super(UserParser.class, context, type.caption, type.variable(input));
        }

        private static enum Type {
            UUID("uuid", SpongeCaptionKeys.ARGUMENT_PARSE_FAILURE_USER_CANNOT_FIND_USER_WITH_UUID),
            NAME("name", SpongeCaptionKeys.ARGUMENT_PARSE_FAILURE_USER_CANNOT_FIND_USER_WITH_NAME),
            INVALID_INPUT("input", SpongeCaptionKeys.ARGUMENT_PARSE_FAILURE_USER_INVALID_INPUT);

            private final String key;
            private final Caption caption;

            private Type(String key, Caption caption) {
                this.key = key;
                this.caption = caption;
            }

            CaptionVariable variable(@NonNull String input) {
                return CaptionVariable.of(this.key, input);
            }
        }
    }
}

