/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.paper.listener;

import com.convallyria.forcepack.paper.ForcePackPaper;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;

public class ExemptionListener
implements Listener {
    private final ForcePackPaper plugin;

    public ExemptionListener(ForcePackPaper plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        Player damager;
        Player player;
        if (!this.plugin.getConfig().getBoolean("prevent-damage")) {
            return;
        }
        if (event.getEntity() instanceof Player && this.plugin.isWaiting(player = (Player)event.getEntity())) {
            event.setCancelled(true);
            this.plugin.log("Cancelled damage for player '" + player.getName() + "' due to resource pack not applied.", new Object[0]);
        }
        if (event.getDamager() instanceof Player && this.plugin.isWaiting(damager = (Player)event.getDamager())) {
            event.setCancelled(true);
            this.plugin.log("Cancelled damage for damager '" + damager.getName() + "' due to resource pack not applied.", new Object[0]);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Player damaged;
        if (!this.plugin.getConfig().getBoolean("prevent-damage")) {
            return;
        }
        if (event.getEntity() instanceof Player && this.plugin.isWaiting(damaged = (Player)event.getEntity())) {
            event.setCancelled(true);
            this.plugin.log("Cancelled damage for player '" + damaged.getName() + "' due to resource pack not applied.", new Object[0]);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onMove(PlayerMoveEvent event) {
        if (!this.plugin.getConfig().getBoolean("prevent-movement")) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isWaiting(player)) {
            event.setCancelled(true);
            this.plugin.log("Cancelled movement for player '" + player.getName() + "' due to resource pack not applied.", new Object[0]);
        }
    }
}

