/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.paper.cloud.suggestion;

import forcepack.libs.paper.cloud.context.CommandContext;
import forcepack.libs.paper.cloud.suggestion.Suggestion;
import forcepack.libs.paper.cloud.suggestion.SuggestionFactory;
import forcepack.libs.paper.cloud.suggestion.SuggestionMapper;
import forcepack.libs.paper.cloud.suggestion.Suggestions;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

final class MappingSuggestionFactory<C, S extends Suggestion>
implements SuggestionFactory<C, S> {
    private final SuggestionFactory<C, ?> other;
    private final SuggestionMapper<S> suggestionMapper;

    MappingSuggestionFactory(@NonNull SuggestionFactory<C, ?> other, @NonNull SuggestionMapper<S> suggestionMapper) {
        this.other = other;
        this.suggestionMapper = suggestionMapper;
    }

    @Override
    public @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggest(@NonNull CommandContext<C> context, @NonNull String input) {
        return this.map(this.other.suggest(context, input));
    }

    @Override
    public @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggest(@NonNull C sender, @NonNull String input) {
        return this.map(this.other.suggest(sender, input));
    }

    @Override
    public <S2 extends Suggestion> @NonNull SuggestionFactory<C, S2> mapped(@NonNull SuggestionMapper<S2> mapper) {
        return new MappingSuggestionFactory<C, S2>(this.other, this.suggestionMapper.then(mapper));
    }

    private <S1 extends Suggestion> @NonNull CompletableFuture<@NonNull Suggestions<C, S>> map(@NonNull CompletableFuture<Suggestions<C, S1>> future) {
        return future.thenApply(suggestions -> Suggestions.create(suggestions.commandContext(), suggestions.list().stream().map(this.suggestionMapper::map).collect(Collectors.toList()), suggestions.commandInput()));
    }
}

