/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.chat.clickevent;

import com.convallyria.forcepack.paper.libs.adventure.adventure.text.event.ClickEvent;
import forcepack.libs.pe.api.protocol.chat.clickevent.ChangePageClickEvent;
import forcepack.libs.pe.api.protocol.chat.clickevent.ClickEventAction;
import forcepack.libs.pe.api.protocol.chat.clickevent.ClickEventActions;
import forcepack.libs.pe.api.protocol.chat.clickevent.CopyToClipboardClickEvent;
import forcepack.libs.pe.api.protocol.chat.clickevent.CustomClickEvent;
import forcepack.libs.pe.api.protocol.chat.clickevent.OpenFileClickEvent;
import forcepack.libs.pe.api.protocol.chat.clickevent.OpenUrlClickEvent;
import forcepack.libs.pe.api.protocol.chat.clickevent.RunCommandClickEvent;
import forcepack.libs.pe.api.protocol.chat.clickevent.ShowDialogClickEvent;
import forcepack.libs.pe.api.protocol.chat.clickevent.SuggestCommandClickEvent;
import forcepack.libs.pe.api.protocol.dialog.Dialog;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.protocol.nbt.NBTEnd;
import forcepack.libs.pe.api.resources.ResourceLocation;
import forcepack.libs.pe.api.util.adventure.NbtTagHolder;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface ClickEvent {
    public static ClickEvent decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        String actionName = compound.getStringTagValueOrThrow("action");
        ClickEventAction action = (ClickEventAction)ClickEventActions.getRegistry().getByNameOrThrow(actionName);
        return action.decode(compound, wrapper);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, ClickEvent clickEvent) {
        compound.set("action", clickEvent.getAction().getName(), ResourceLocation::encode, wrapper);
        clickEvent.getAction().encode(compound, wrapper, clickEvent);
    }

    public ClickEventAction<?> getAction();

    public static ClickEvent fromAdventure(com.convallyria.forcepack.paper.libs.adventure.adventure.text.event.ClickEvent clickEvent) {
        switch (clickEvent.action()) {
            case OPEN_URL: {
                return new OpenUrlClickEvent(clickEvent.value());
            }
            case OPEN_FILE: {
                return new OpenFileClickEvent(clickEvent.value());
            }
            case RUN_COMMAND: {
                return new RunCommandClickEvent(clickEvent.value());
            }
            case SUGGEST_COMMAND: {
                return new SuggestCommandClickEvent(clickEvent.value());
            }
            case CHANGE_PAGE: {
                return new ChangePageClickEvent(clickEvent.value());
            }
            case COPY_TO_CLIPBOARD: {
                return new CopyToClipboardClickEvent(clickEvent.value());
            }
            case SHOW_DIALOG: {
                return new ShowDialogClickEvent((Dialog)((ClickEvent.Payload.Dialog)clickEvent.payload()).dialog());
            }
            case CUSTOM: {
                ClickEvent.Payload.Custom payload = (ClickEvent.Payload.Custom)clickEvent.payload();
                NbtTagHolder nbtTag = (NbtTagHolder)payload.nbt();
                return new CustomClickEvent(new ResourceLocation(payload.key()), nbtTag.getTag() instanceof NBTEnd ? null : nbtTag.getTag());
            }
        }
        throw new UnsupportedOperationException("Unsupported clickevent: " + clickEvent);
    }

    public com.convallyria.forcepack.paper.libs.adventure.adventure.text.event.ClickEvent asAdventure();
}

