/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.dialog.body;

import forcepack.libs.pe.api.protocol.dialog.body.DialogBodyType;
import forcepack.libs.pe.api.protocol.dialog.body.DialogBodyTypes;
import forcepack.libs.pe.api.protocol.nbt.NBT;
import forcepack.libs.pe.api.protocol.nbt.NBTCompound;
import forcepack.libs.pe.api.resources.ResourceLocation;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface DialogBody {
    public static DialogBody decode(NBT nbt, PacketWrapper<?> wrapper) {
        NBTCompound compound = (NBTCompound)nbt;
        String typeName = compound.getStringTagValueOrThrow("type");
        DialogBodyType type = (DialogBodyType)DialogBodyTypes.getRegistry().getByNameOrThrow(typeName);
        return type.decode(compound, wrapper);
    }

    public static NBT encode(PacketWrapper<?> wrapper, DialogBody body) {
        NBTCompound compound = new NBTCompound();
        compound.set("type", body.getType().getName(), ResourceLocation::encode, wrapper);
        body.getType().encode(compound, wrapper, body);
        return compound;
    }

    public DialogBodyType<?> getType();
}

