/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.wrapper.play.server;

import com.convallyria.forcepack.paper.libs.adventure.adventure.text.Component;
import com.convallyria.forcepack.paper.libs.adventure.adventure.text.TextComponent;
import forcepack.libs.pe.api.event.PacketSendEvent;
import forcepack.libs.pe.api.manager.server.ServerVersion;
import forcepack.libs.pe.api.protocol.packettype.PacketType;
import forcepack.libs.pe.api.protocol.player.GameMode;
import forcepack.libs.pe.api.protocol.player.TextureProperty;
import forcepack.libs.pe.api.protocol.player.UserProfile;
import forcepack.libs.pe.api.util.crypto.SignatureData;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerPlayerInfo
extends PacketWrapper<WrapperPlayServerPlayerInfo> {
    @Nullable
    private Action action;
    private List<PlayerData> playerDataList;

    public WrapperPlayServerPlayerInfo(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerPlayerInfo(@NotNull Action action, List<PlayerData> playerDataList) {
        super(PacketType.Play.Server.PLAYER_INFO);
        this.action = action;
        this.playerDataList = playerDataList;
    }

    public WrapperPlayServerPlayerInfo(@NotNull Action action, PlayerData ... playerData) {
        super(PacketType.Play.Server.PLAYER_INFO);
        this.action = action;
        this.playerDataList = new ArrayList<PlayerData>();
        Collections.addAll(this.playerDataList, playerData);
    }

    @Override
    public void read() {
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.playerDataList = new ArrayList<PlayerData>(1);
            String rawUsername = this.readString();
            TextComponent username = Component.text(rawUsername);
            boolean online = this.readBoolean();
            short ping = this.readShort();
            PlayerData data = new PlayerData(username, null, GameMode.SURVIVAL, ping);
            this.playerDataList.add(data);
            this.action = online ? null : Action.REMOVE_PLAYER;
        } else {
            this.action = Action.VALUES[this.readVarInt()];
            int playerDataCount = this.readVarInt();
            this.playerDataList = new ArrayList<PlayerData>(playerDataCount);
            for (int i = 0; i < playerDataCount; ++i) {
                PlayerData data = null;
                UUID uuid = this.readUUID();
                switch (this.action.ordinal()) {
                    case 0: {
                        String playerUsername = this.readString(16);
                        UserProfile userProfile = new UserProfile(uuid, playerUsername);
                        int propertyCount = this.readVarInt();
                        for (int j = 0; j < propertyCount; ++j) {
                            String propertyName = this.readString();
                            String propertyValue = this.readString();
                            String propertySignature = (String)this.readOptional(PacketWrapper::readString);
                            TextureProperty textureProperty = new TextureProperty(propertyName, propertyValue, propertySignature);
                            userProfile.getTextureProperties().add(textureProperty);
                        }
                        GameMode gameMode = GameMode.getById(this.readVarInt());
                        int ping = this.readVarInt();
                        Component displayName = this.readBoolean() ? this.readComponent() : null;
                        SignatureData signatureData = null;
                        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
                            signatureData = (SignatureData)this.readOptional(PacketWrapper::readSignatureData);
                        }
                        data = new PlayerData(displayName, userProfile, gameMode, signatureData, ping);
                        break;
                    }
                    case 1: {
                        GameMode gameMode = GameMode.getById(this.readVarInt());
                        data = new PlayerData(null, new UserProfile(uuid, null), gameMode, -1);
                        break;
                    }
                    case 2: {
                        int ping = this.readVarInt();
                        data = new PlayerData(null, new UserProfile(uuid, null), null, ping);
                        break;
                    }
                    case 3: {
                        Component displayName = this.readBoolean() ? this.readComponent() : null;
                        data = new PlayerData(displayName, new UserProfile(uuid, null), null, -1);
                        break;
                    }
                    case 4: {
                        data = new PlayerData(null, new UserProfile(uuid, null), null, -1);
                    }
                }
                if (data == null) continue;
                this.playerDataList.add(data);
            }
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            PlayerData data = this.playerDataList.get(0);
            String rawUsername = ((TextComponent)data.displayName).content();
            this.writeString(rawUsername);
            this.writeBoolean(this.action != Action.REMOVE_PLAYER);
            this.writeShort(data.ping);
        } else {
            this.writeVarInt(this.action.ordinal());
            this.writeVarInt(this.playerDataList.size());
            for (PlayerData data : this.playerDataList) {
                this.writeUUID(data.userProfile.getUUID());
                switch (this.action.ordinal()) {
                    case 0: {
                        this.writeString(data.userProfile.getName(), 16);
                        this.writeList(data.userProfile.getTextureProperties(), (wrapper, textureProperty) -> {
                            wrapper.writeString(textureProperty.getName());
                            wrapper.writeString(textureProperty.getValue());
                            wrapper.writeOptional(textureProperty.getSignature(), PacketWrapper::writeString);
                        });
                        this.writeVarInt(data.gameMode.ordinal());
                        this.writeVarInt(data.ping);
                        if (data.displayName != null) {
                            this.writeBoolean(true);
                            this.writeComponent(data.displayName);
                        } else {
                            this.writeBoolean(false);
                        }
                        if (!this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) break;
                        this.writeOptional(data.getSignatureData(), PacketWrapper::writeSignatureData);
                        break;
                    }
                    case 1: {
                        this.writeVarInt(data.gameMode.ordinal());
                        break;
                    }
                    case 2: {
                        this.writeVarInt(data.ping);
                        break;
                    }
                    case 3: {
                        if (data.displayName != null) {
                            this.writeBoolean(true);
                            this.writeComponent(data.displayName);
                            break;
                        }
                        this.writeBoolean(false);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerPlayerInfo wrapper) {
        this.action = wrapper.action;
        this.playerDataList = wrapper.playerDataList;
    }

    @Nullable
    public Action getAction() {
        return this.action;
    }

    public void setAction(@NotNull Action action) {
        this.action = action;
    }

    public List<PlayerData> getPlayerDataList() {
        return this.playerDataList;
    }

    public void setPlayerDataList(List<PlayerData> playerDataList) {
        this.playerDataList = playerDataList;
    }

    public static enum Action {
        ADD_PLAYER,
        UPDATE_GAME_MODE,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        REMOVE_PLAYER;

        public static final Action[] VALUES;

        static {
            VALUES = Action.values();
        }
    }

    public static class PlayerData {
        @Nullable
        private Component displayName;
        @Nullable
        private UserProfile userProfile;
        @Nullable
        private GameMode gameMode;
        @Nullable
        private SignatureData signatureData;
        private int ping;

        public PlayerData(@Nullable Component displayName, @Nullable UserProfile userProfile, @Nullable GameMode gameMode, @Nullable SignatureData signatureData, int ping) {
            this.displayName = displayName;
            this.userProfile = userProfile;
            this.gameMode = gameMode;
            this.signatureData = signatureData;
            this.ping = ping;
        }

        public PlayerData(@Nullable Component displayName, @Nullable UserProfile userProfile, @Nullable GameMode gameMode, int ping) {
            this(displayName, userProfile, gameMode, null, ping);
        }

        @Nullable
        public UserProfile getUserProfile() {
            return this.userProfile;
        }

        public void setUserProfile(@Nullable UserProfile userProfile) {
            this.userProfile = userProfile;
        }

        public SignatureData getSignatureData() {
            return this.signatureData;
        }

        public void setSignatureData(SignatureData signatureData) {
            this.signatureData = signatureData;
        }

        @Deprecated
        @Nullable
        public UserProfile getUser() {
            return this.userProfile;
        }

        @Deprecated
        public void setUser(@Nullable UserProfile userProfile) {
            this.userProfile = userProfile;
        }

        @Nullable
        public GameMode getGameMode() {
            return this.gameMode;
        }

        public void setGameMode(@Nullable GameMode gameMode) {
            this.gameMode = gameMode;
        }

        public int getPing() {
            return this.ping;
        }

        public void setPing(int ping) {
            this.ping = ping;
        }

        @Nullable
        public Component getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(@Nullable Component displayName) {
            this.displayName = displayName;
        }
    }
}

