/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.sponge.resourcepack;

import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.resourcepack.ResourcePackVersion;
import com.convallyria.forcepack.sponge.ForcePackSponge;
import com.convallyria.forcepack.sponge.util.ProtocolUtil;
import forcepack.libs.pe.api.wrapper.play.server.WrapperPlayServerResourcePackSend;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;

public final class SpongeResourcePack
extends ResourcePack {
    private final ForcePackSponge spongePlugin;

    public SpongeResourcePack(ForcePackSponge plugin, String url, String hash, int size, @Nullable ResourcePackVersion packVersion) {
        this(plugin, "Sponge", url, hash, size, packVersion);
    }

    public SpongeResourcePack(ForcePackSponge plugin, String server, String url, String hash, int size, @Nullable ResourcePackVersion packVersion) {
        super(plugin, server, url, hash, size, packVersion);
        this.spongePlugin = plugin;
    }

    @Override
    public void setResourcePack(UUID uuid) {
        int delay = this.spongePlugin.getConfig().node(new Object[]{"delay-pack-sending-by"}).getInt(0);
        if (delay > 0) {
            this.plugin.getScheduler().executeDelayed(() -> this.runSetResourcePack(uuid), delay);
        } else {
            this.runSetResourcePack(uuid);
        }
    }

    private void runSetResourcePack(UUID uuid) {
        ServerPlayer player = Sponge.server().player(uuid).orElse(null);
        if (player == null) {
            return;
        }
        this.spongePlugin.getForcePackPlayer(player).ifPresent(forcePackPlayer -> forcePackPlayer.getChecks().forEach(check -> check.sendPack(this)));
        WrapperPlayServerResourcePackSend send = new WrapperPlayServerResourcePackSend(this.getUUID(), this.url, this.getHash(), this.spongePlugin.getConfig().node(new Object[]{"use-new-force-pack-screen"}).getBoolean(true), Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{Component.translatable((String)"forcepack.prompt_text")}));
        ProtocolUtil.sendPacketBypassingVia(player, send);
    }
}

