/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api;

import forcepack.libs.pe.api.event.EventManager;
import forcepack.libs.pe.api.injector.ChannelInjector;
import forcepack.libs.pe.api.manager.player.PlayerManager;
import forcepack.libs.pe.api.manager.protocol.ProtocolManager;
import forcepack.libs.pe.api.manager.server.ServerManager;
import forcepack.libs.pe.api.netty.NettyManager;
import forcepack.libs.pe.api.settings.PacketEventsSettings;
import forcepack.libs.pe.api.util.LogManager;
import forcepack.libs.pe.api.util.PEVersion;
import forcepack.libs.pe.api.util.PEVersions;
import forcepack.libs.pe.api.util.updatechecker.UpdateChecker;
import java.util.logging.Logger;

public abstract class PacketEventsAPI<T> {
    private final EventManager eventManager = new EventManager();
    private final PacketEventsSettings settings = new PacketEventsSettings();
    private final UpdateChecker updateChecker = new UpdateChecker();
    private final LogManager logManager = new LogManager();
    private static final Logger LOGGER = Logger.getLogger(PacketEventsAPI.class.getName());

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public PacketEventsSettings getSettings() {
        return this.settings;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public PEVersion getVersion() {
        return PEVersions.CURRENT;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public abstract void load();

    public abstract boolean isLoaded();

    public abstract void init();

    public abstract boolean isInitialized();

    public abstract void terminate();

    public abstract boolean isTerminated();

    public abstract T getPlugin();

    public abstract ServerManager getServerManager();

    public abstract ProtocolManager getProtocolManager();

    public abstract PlayerManager getPlayerManager();

    public abstract NettyManager getNettyManager();

    public abstract ChannelInjector getInjector();
}

