/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.impl.adventure.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import forcepack.libs.pe.impl.adventure.option.OptionState;
import forcepack.libs.pe.impl.adventure.serializer.gson.BackwardCompatUtil;
import forcepack.libs.pe.impl.adventure.serializer.gson.BlockNBTComponentPosSerializer;
import forcepack.libs.pe.impl.adventure.serializer.gson.ClickEventActionSerializer;
import forcepack.libs.pe.impl.adventure.serializer.gson.ComponentSerializerImpl;
import forcepack.libs.pe.impl.adventure.serializer.gson.HoverEventActionSerializer;
import forcepack.libs.pe.impl.adventure.serializer.gson.KeySerializer;
import forcepack.libs.pe.impl.adventure.serializer.gson.ProfilePropertySerializer;
import forcepack.libs.pe.impl.adventure.serializer.gson.ShadowColorSerializer;
import forcepack.libs.pe.impl.adventure.serializer.gson.ShowEntitySerializer;
import forcepack.libs.pe.impl.adventure.serializer.gson.ShowItemSerializer;
import forcepack.libs.pe.impl.adventure.serializer.gson.StyleSerializer;
import forcepack.libs.pe.impl.adventure.serializer.gson.TextColorSerializer;
import forcepack.libs.pe.impl.adventure.serializer.gson.TextColorWrapper;
import forcepack.libs.pe.impl.adventure.serializer.gson.TextDecorationSerializer;
import forcepack.libs.pe.impl.adventure.serializer.gson.TranslationArgumentSerializer;
import forcepack.libs.pe.impl.adventure.serializer.gson.UUIDSerializer;
import forcepack.libs.pe.impl.adventure.serializer.json.JSONOptions;
import forcepack.libs.pe.impl.adventure.serializer.json.LegacyHoverEventSerializer;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import org.jetbrains.annotations.Nullable;

final class SerializerFactory
implements TypeAdapterFactory {
    static final Class<Key> KEY_TYPE = Key.class;
    static final Class<Component> COMPONENT_TYPE = Component.class;
    static final Class<Style> STYLE_TYPE = Style.class;
    static final Class<ClickEvent.Action> CLICK_ACTION_TYPE = ClickEvent.Action.class;
    static final Class<HoverEvent.Action> HOVER_ACTION_TYPE = HoverEvent.Action.class;
    static final Class<HoverEvent.ShowItem> SHOW_ITEM_TYPE = HoverEvent.ShowItem.class;
    static final Class<HoverEvent.ShowEntity> SHOW_ENTITY_TYPE = HoverEvent.ShowEntity.class;
    static final Class<String> STRING_TYPE = String.class;
    static final Class<TextColorWrapper> COLOR_WRAPPER_TYPE = TextColorWrapper.class;
    static final Class<TextColor> COLOR_TYPE = TextColor.class;
    static final Class<?> SHADOW_COLOR_TYPE;
    static final Class<TextDecoration> TEXT_DECORATION_TYPE;
    static final Class<BlockNBTComponent.Pos> BLOCK_NBT_POS_TYPE;
    static final Class<UUID> UUID_TYPE;
    static final Class<?> TRANSLATION_ARGUMENT_TYPE;
    static final Class<?> PROFILE_PROPERTY_TYPE;
    private final OptionState features;
    private final LegacyHoverEventSerializer legacyHoverSerializer;
    private final BackwardCompatUtil.ShowAchievementToComponent compatShowAchievement;

    SerializerFactory(OptionState features, @Nullable LegacyHoverEventSerializer legacyHoverSerializer, @Nullable BackwardCompatUtil.ShowAchievementToComponent compatShowAchievement) {
        this.features = features;
        this.legacyHoverSerializer = legacyHoverSerializer;
        this.compatShowAchievement = compatShowAchievement;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (COMPONENT_TYPE.isAssignableFrom(rawType)) {
            return ComponentSerializerImpl.create(this.features, gson);
        }
        if (KEY_TYPE.isAssignableFrom(rawType)) {
            return KeySerializer.INSTANCE;
        }
        if (STYLE_TYPE.isAssignableFrom(rawType)) {
            return StyleSerializer.create(this.legacyHoverSerializer, this.compatShowAchievement, this.features, gson);
        }
        if (CLICK_ACTION_TYPE.isAssignableFrom(rawType)) {
            return ClickEventActionSerializer.INSTANCE;
        }
        if (HOVER_ACTION_TYPE.isAssignableFrom(rawType)) {
            return HoverEventActionSerializer.INSTANCE;
        }
        if (SHOW_ITEM_TYPE.isAssignableFrom(rawType)) {
            return ShowItemSerializer.create(gson, this.features);
        }
        if (SHOW_ENTITY_TYPE.isAssignableFrom(rawType)) {
            return ShowEntitySerializer.create(gson, this.features);
        }
        if (COLOR_WRAPPER_TYPE.isAssignableFrom(rawType)) {
            return TextColorWrapper.Serializer.INSTANCE;
        }
        if (COLOR_TYPE.isAssignableFrom(rawType)) {
            return this.features.value(JSONOptions.EMIT_RGB) != false ? TextColorSerializer.INSTANCE : TextColorSerializer.DOWNSAMPLE_COLOR;
        }
        if (BackwardCompatUtil.IS_4_18_0_OR_NEWER && SHADOW_COLOR_TYPE.isAssignableFrom(rawType)) {
            return ShadowColorSerializer.create(this.features);
        }
        if (TEXT_DECORATION_TYPE.isAssignableFrom(rawType)) {
            return TextDecorationSerializer.INSTANCE;
        }
        if (BLOCK_NBT_POS_TYPE.isAssignableFrom(rawType)) {
            return BlockNBTComponentPosSerializer.INSTANCE;
        }
        if (UUID_TYPE.isAssignableFrom(rawType)) {
            return UUIDSerializer.uuidSerializer(this.features);
        }
        if (BackwardCompatUtil.IS_4_15_0_OR_NEWER && TRANSLATION_ARGUMENT_TYPE.isAssignableFrom(rawType)) {
            return TranslationArgumentSerializer.create(gson);
        }
        if (BackwardCompatUtil.IS_4_25_0_OR_NEWER && PROFILE_PROPERTY_TYPE.isAssignableFrom(rawType)) {
            return ProfilePropertySerializer.INSTANCE;
        }
        return null;
    }

    static {
        TEXT_DECORATION_TYPE = TextDecoration.class;
        BLOCK_NBT_POS_TYPE = BlockNBTComponent.Pos.class;
        UUID_TYPE = UUID.class;
        TRANSLATION_ARGUMENT_TYPE = BackwardCompatUtil.IS_4_15_0_OR_NEWER ? TranslationArgument.class : null;
        SHADOW_COLOR_TYPE = BackwardCompatUtil.IS_4_18_0_OR_NEWER ? ShadowColor.class : null;
        PROFILE_PROPERTY_TYPE = BackwardCompatUtil.IS_4_25_0_OR_NEWER ? PlayerHeadObjectContents.ProfileProperty.class : null;
    }
}

