/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.sponge.cloud.sponge.parser;

import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import forcepack.libs.sponge.cloud.parser.ArgumentParseResult;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;

final class ResourceKeyUtil {
    private static final SimpleCommandExceptionType ERROR_INVALID_RESOURCE_LOCATION;

    private ResourceKeyUtil() {
    }

    static <T> ArgumentParseResult<T> invalidResourceKey() {
        return ArgumentParseResult.failure(ERROR_INVALID_RESOURCE_LOCATION.create());
    }

    static @Nullable ResourceKey resourceKey(@NonNull String input) {
        try {
            return ResourceKey.resolve((String)input);
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    static {
        try {
            Field errorInvalidResourceLocationField = Arrays.stream(ResourceLocation.class.getDeclaredFields()).filter(it -> it.getType().equals(SimpleCommandExceptionType.class)).findFirst().orElseThrow(IllegalStateException::new);
            errorInvalidResourceLocationField.setAccessible(true);
            ERROR_INVALID_RESOURCE_LOCATION = (SimpleCommandExceptionType)errorInvalidResourceLocationField.get(null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't access ERROR_INVALID command exception type.", ex);
        }
    }
}

