/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload;

import com.google.errorprone.annotations.CheckReturnValue;
import dev.vankka.dependencydownload.DependencyManager;
import dev.vankka.dependencydownload.dependency.Dependency;
import dev.vankka.dependencydownload.path.DependencyPathProvider;
import dev.vankka.dependencydownload.path.DirectoryDependencyPathProvider;
import dev.vankka.dependencydownload.relocation.Relocation;
import dev.vankka.dependencydownload.resource.DependencyDownloadResource;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;

public class ApplicationDependencyManager {
    private final Set<Dependency> dependencies = new CopyOnWriteArraySet<Dependency>();
    private final Set<Relocation> relocations = new CopyOnWriteArraySet<Relocation>();
    private final DependencyPathProvider dependencyPathProvider;

    public ApplicationDependencyManager(@NotNull Path cacheDirectory) {
        this(new DirectoryDependencyPathProvider(cacheDirectory));
    }

    public ApplicationDependencyManager(@NotNull DependencyPathProvider dependencyPathProvider) {
        this.dependencyPathProvider = dependencyPathProvider;
    }

    public void addRelocations(@NotNull Collection<Relocation> relocations) {
        this.relocations.addAll(relocations);
    }

    public void addRelocation(@NotNull Relocation relocation) {
        this.relocations.add(relocation);
    }

    @CheckReturnValue
    public DependencyManager includeResource(@NotNull URL resourceURL) throws IOException {
        DependencyDownloadResource resource = new DependencyDownloadResource(resourceURL);
        return this.includeResource(resource);
    }

    @CheckReturnValue
    public DependencyManager includeResource(@NotNull String resourceContent) {
        DependencyDownloadResource resource = new DependencyDownloadResource(resourceContent);
        return this.includeResource(resource);
    }

    @CheckReturnValue
    public DependencyManager includeResource(@NotNull List<String> resourceLines) {
        DependencyDownloadResource resource = new DependencyDownloadResource(resourceLines);
        return this.includeResource(resource);
    }

    public DependencyManager includeResource(@NotNull DependencyDownloadResource resource) {
        return this.include(resource.getDependencies(), resource.getRelocations());
    }

    @CheckReturnValue
    public DependencyManager include(@NotNull List<Dependency> dependencies, @NotNull List<Relocation> relocations) {
        this.addRelocations(relocations);
        return this.include(dependencies);
    }

    @CheckReturnValue
    public DependencyManager include(@NotNull Collection<Dependency> dependencies) {
        dependencies = this.dependencies(dependencies);
        DependencyManager manager = new DependencyManager(this.dependencyPathProvider);
        manager.addDependencies(dependencies);
        manager.addRelocations(this.relocations);
        return manager;
    }

    @CheckReturnValue
    public DependencyManager include(@NotNull DependencyManager manager) {
        this.addRelocations(manager.getRelocations());
        List<Dependency> dependencies = this.dependencies(manager.getDependencies());
        DependencyManager dependencyManager = new DependencyManager(manager.getDependencyPathProvider());
        dependencyManager.addDependencies(dependencies);
        dependencyManager.addRelocations(this.relocations);
        return dependencyManager;
    }

    private List<Dependency> dependencies(Collection<Dependency> old) {
        ArrayList<Dependency> newDependencies = new ArrayList<Dependency>(old.size());
        for (Dependency dependency : old) {
            String group = dependency.getGroupId();
            String artifact = dependency.getArtifactId();
            boolean noMatch = this.dependencies.stream().noneMatch(dep -> dep.getGroupId().equals(group) && dep.getArtifactId().equals(artifact));
            if (!noMatch || !this.dependencies.add(dependency)) continue;
            newDependencies.add(dependency);
        }
        return newDependencies;
    }
}

