/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.recipe.display;

import forcepack.libs.pe.api.protocol.recipe.display.RecipeDisplay;
import forcepack.libs.pe.api.protocol.recipe.display.RecipeDisplayTypes;
import forcepack.libs.pe.api.protocol.recipe.display.slot.SlotDisplay;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import java.util.List;
import java.util.Objects;

public class ShapelessCraftingRecipeDisplay
extends RecipeDisplay<ShapelessCraftingRecipeDisplay> {
    private List<SlotDisplay<?>> ingredients;
    private SlotDisplay<?> result;
    private SlotDisplay<?> craftingStation;

    public ShapelessCraftingRecipeDisplay(List<SlotDisplay<?>> ingredients, SlotDisplay<?> result, SlotDisplay<?> craftingStation) {
        super(RecipeDisplayTypes.CRAFTING_SHAPELESS);
        this.ingredients = ingredients;
        this.result = result;
        this.craftingStation = craftingStation;
    }

    public static ShapelessCraftingRecipeDisplay read(PacketWrapper<?> wrapper) {
        List<SlotDisplay<?>> ingredients = wrapper.readList(SlotDisplay::read);
        SlotDisplay<?> result = SlotDisplay.read(wrapper);
        SlotDisplay<?> craftingStation = SlotDisplay.read(wrapper);
        return new ShapelessCraftingRecipeDisplay(ingredients, result, craftingStation);
    }

    public static void write(PacketWrapper<?> wrapper, ShapelessCraftingRecipeDisplay display) {
        wrapper.writeList(display.ingredients, SlotDisplay::write);
        SlotDisplay.write(wrapper, display.result);
        SlotDisplay.write(wrapper, display.craftingStation);
    }

    public List<SlotDisplay<?>> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(List<SlotDisplay<?>> ingredients) {
        this.ingredients = ingredients;
    }

    public SlotDisplay<?> getResult() {
        return this.result;
    }

    public void setResult(SlotDisplay<?> result) {
        this.result = result;
    }

    public SlotDisplay<?> getCraftingStation() {
        return this.craftingStation;
    }

    public void setCraftingStation(SlotDisplay<?> craftingStation) {
        this.craftingStation = craftingStation;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShapelessCraftingRecipeDisplay)) {
            return false;
        }
        ShapelessCraftingRecipeDisplay that = (ShapelessCraftingRecipeDisplay)obj;
        if (!this.ingredients.equals(that.ingredients)) {
            return false;
        }
        if (!this.result.equals(that.result)) {
            return false;
        }
        return this.craftingStation.equals(that.craftingStation);
    }

    public int hashCode() {
        return Objects.hash(this.ingredients, this.result, this.craftingStation);
    }

    public String toString() {
        return "ShapelessCraftingRecipeDisplay{ingredients=" + this.ingredients + ", result=" + this.result + ", craftingStation=" + this.craftingStation + '}';
    }
}

