/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.world.chunk.impl.v_1_18;

import forcepack.libs.pe.api.manager.server.ServerVersion;
import forcepack.libs.pe.api.protocol.stream.NetStreamInput;
import forcepack.libs.pe.api.protocol.stream.NetStreamInputWrapper;
import forcepack.libs.pe.api.protocol.stream.NetStreamOutput;
import forcepack.libs.pe.api.protocol.stream.NetStreamOutputWrapper;
import forcepack.libs.pe.api.protocol.world.chunk.BaseChunk;
import forcepack.libs.pe.api.protocol.world.chunk.palette.DataPalette;
import forcepack.libs.pe.api.protocol.world.chunk.palette.PaletteType;
import forcepack.libs.pe.api.wrapper.PacketWrapper;

public class Chunk_v1_18
implements BaseChunk {
    private static final int AIR = 0;
    private int blockCount;
    private final DataPalette chunkData;
    private final DataPalette biomeData;

    public Chunk_v1_18() {
        this.chunkData = PaletteType.CHUNK.create();
        this.biomeData = PaletteType.BIOME.create();
    }

    public Chunk_v1_18(int blockCount, DataPalette chunkData, DataPalette biomeData) {
        this.blockCount = blockCount;
        this.chunkData = chunkData;
        this.biomeData = biomeData;
    }

    public static Chunk_v1_18 read(PacketWrapper<?> wrapper) {
        boolean paletteLengthPrefix = wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_21_5);
        return Chunk_v1_18.read(new NetStreamInputWrapper(wrapper), paletteLengthPrefix);
    }

    @Deprecated
    public static Chunk_v1_18 read(NetStreamInput in) {
        return Chunk_v1_18.read(in, true);
    }

    @Deprecated
    public static Chunk_v1_18 read(NetStreamInput in, boolean paletteLengthPrefix) {
        short blockCount = in.readShort();
        DataPalette chunkPalette = DataPalette.read(in, PaletteType.CHUNK, true, paletteLengthPrefix);
        DataPalette biomePalette = DataPalette.read(in, PaletteType.BIOME, true, paletteLengthPrefix);
        return new Chunk_v1_18(blockCount, chunkPalette, biomePalette);
    }

    public static void write(PacketWrapper<?> wrapper, Chunk_v1_18 section) {
        boolean paletteLengthPrefix = wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_21_5);
        Chunk_v1_18.write(new NetStreamOutputWrapper(wrapper), section, paletteLengthPrefix);
    }

    @Deprecated
    public static void write(NetStreamOutput out, Chunk_v1_18 section) {
        Chunk_v1_18.write(out, section, true);
    }

    @Deprecated
    public static void write(NetStreamOutput out, Chunk_v1_18 section, boolean paletteLengthPrefix) {
        out.writeShort(section.blockCount);
        DataPalette.write(out, section.chunkData, paletteLengthPrefix);
        DataPalette.write(out, section.biomeData, paletteLengthPrefix);
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        return this.chunkData.get(x, y, z);
    }

    @Override
    public void set(int x, int y, int z, int state) {
        int curr = this.chunkData.set(x, y, z, state);
        if (state != 0 && curr == 0) {
            ++this.blockCount;
        } else if (state == 0 && curr != 0) {
            --this.blockCount;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.blockCount == 0;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void setBlockCount(int blockCount) {
        this.blockCount = blockCount;
    }

    public DataPalette getChunkData() {
        return this.chunkData;
    }

    public DataPalette getBiomeData() {
        return this.biomeData;
    }
}

