/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.protocol.world.waypoint;

import forcepack.libs.pe.api.protocol.color.Color;
import forcepack.libs.pe.api.resources.ResourceLocation;
import forcepack.libs.pe.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class WaypointIcon {
    public static final ResourceLocation ICON_STYLE_DEFAULT = new ResourceLocation("default");
    public static final ResourceLocation ICON_STYLE_BOWTIE = new ResourceLocation("bowtie");
    private final ResourceLocation style;
    private final @Nullable Color color;

    public WaypointIcon(ResourceLocation style, @Nullable Color color) {
        this.style = style;
        this.color = color;
    }

    public static WaypointIcon read(PacketWrapper<?> wrapper) {
        ResourceLocation style = wrapper.readIdentifier();
        Color color = (Color)wrapper.readOptional(Color::readShort);
        return new WaypointIcon(style, color);
    }

    public static void write(PacketWrapper<?> wrapper, WaypointIcon icon) {
        wrapper.writeIdentifier(icon.style);
        wrapper.writeOptional(icon.color, Color::writeShort);
    }

    public ResourceLocation getStyle() {
        return this.style;
    }

    public @Nullable Color getColor() {
        return this.color;
    }
}

