/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.api.util.mappings;

import forcepack.libs.pe.api.protocol.mapper.MappedEntity;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.resources.ResourceLocation;
import java.util.Collection;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface IRegistry<T extends MappedEntity>
extends BiFunction<ClientVersion, Integer, T> {
    default public T getByNameOrThrow(ResourceLocation name) {
        T value = this.getByName(name);
        if (value == null) {
            throw new IllegalArgumentException("Can't resolve '" + name + "' in '" + this.getRegistryKey() + "'");
        }
        return value;
    }

    @Nullable
    default public T getByName(ResourceLocation name) {
        return this.getByName(name.toString());
    }

    default public T getByNameOrThrow(String name) {
        T value = this.getByName(name);
        if (value == null) {
            String normedName = ResourceLocation.normString(name);
            throw new IllegalArgumentException("Can't resolve '" + normedName + "' in '" + this.getRegistryKey() + "'");
        }
        return value;
    }

    @Nullable
    public T getByName(String var1);

    default public T getByIdOrThrow(ClientVersion version, int id) {
        T value = this.getById(version, id);
        if (value == null) {
            throw new IllegalArgumentException("Can't resolve #" + id + " (" + (Object)((Object)version) + ") in '" + this.getRegistryKey() + "'");
        }
        return value;
    }

    @Nullable
    public T getById(ClientVersion var1, int var2);

    default public int getId(String entityName, ClientVersion version) {
        return this.getId((MappedEntity)this.getByNameOrThrow(entityName), version);
    }

    public int getId(MappedEntity var1, ClientVersion var2);

    public Collection<T> getEntries();

    public int size();

    public ResourceLocation getRegistryKey();

    @Override
    default public T apply(ClientVersion version, Integer id) {
        return this.getByIdOrThrow(version, id);
    }
}

