/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.impl.sponge.factory;

import forcepack.libs.pe.api.PacketEvents;
import forcepack.libs.pe.api.PacketEventsAPI;
import forcepack.libs.pe.api.injector.ChannelInjector;
import forcepack.libs.pe.api.manager.player.PlayerManager;
import forcepack.libs.pe.api.manager.protocol.ProtocolManager;
import forcepack.libs.pe.api.manager.server.ServerManager;
import forcepack.libs.pe.api.netty.NettyManager;
import forcepack.libs.pe.api.protocol.packettype.PacketType;
import forcepack.libs.pe.api.protocol.player.User;
import forcepack.libs.pe.api.protocol.world.states.WrappedBlockState;
import forcepack.libs.pe.api.settings.PacketEventsSettings;
import forcepack.libs.pe.api.util.LogManager;
import forcepack.libs.pe.impl.sponge.InternalSpongeListener;
import forcepack.libs.pe.impl.sponge.injector.SpongeChannelInjector;
import forcepack.libs.pe.impl.sponge.injector.connection.ServerConnectionInitializer;
import forcepack.libs.pe.impl.sponge.manager.InternalSpongePacketListener;
import forcepack.libs.pe.impl.sponge.manager.player.PlayerManagerImpl;
import forcepack.libs.pe.impl.sponge.manager.protocol.ProtocolManagerImpl;
import forcepack.libs.pe.impl.sponge.manager.server.ServerManagerImpl;
import forcepack.libs.pe.impl.sponge.netty.NettyManagerImpl;
import forcepack.libs.pe.impl.sponge.util.SpongeLogManager;
import forcepack.libs.pe.impl.sponge.util.SpongeReflectionUtil;
import forcepack.libs.pe.impl.sponge.util.viaversion.CustomPipelineUtil;
import forcepack.libs.pe.impl.sponge.util.viaversion.ViaVersionUtil;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.plugin.PluginContainer;

public class SpongePacketEventsBuilder {
    private static PacketEventsAPI<PluginContainer> API_INSTANCE;

    public static void clearBuildCache() {
        API_INSTANCE = null;
    }

    public static PacketEventsAPI<PluginContainer> build(PluginContainer plugin) {
        if (API_INSTANCE == null) {
            API_INSTANCE = SpongePacketEventsBuilder.buildNoCache(plugin);
        }
        return API_INSTANCE;
    }

    public static PacketEventsAPI<PluginContainer> build(PluginContainer plugin, PacketEventsSettings settings) {
        if (API_INSTANCE == null) {
            API_INSTANCE = SpongePacketEventsBuilder.buildNoCache(plugin, settings);
        }
        return API_INSTANCE;
    }

    public static PacketEventsAPI<PluginContainer> buildNoCache(PluginContainer plugin) {
        return SpongePacketEventsBuilder.buildNoCache(plugin, new PacketEventsSettings());
    }

    public static PacketEventsAPI<PluginContainer> buildNoCache(final PluginContainer plugin, final PacketEventsSettings inSettings) {
        return new PacketEventsAPI<PluginContainer>(){
            private final PacketEventsSettings settings;
            private final ProtocolManager protocolManager;
            private final ServerManager serverManager;
            private final PlayerManager playerManager;
            private final NettyManager nettyManager;
            private final SpongeChannelInjector injector;
            private final LogManager logManager;
            private boolean loaded;
            private boolean initialized;
            private boolean terminated;
            private boolean lateBind;
            {
                this.settings = inSettings;
                this.protocolManager = new ProtocolManagerImpl();
                this.serverManager = new ServerManagerImpl();
                this.playerManager = new PlayerManagerImpl();
                this.nettyManager = new NettyManagerImpl();
                this.injector = new SpongeChannelInjector();
                this.logManager = new SpongeLogManager();
                this.lateBind = false;
            }

            @Override
            public void load() {
                if (this.loaded) {
                    return;
                }
                String id = plugin.metadata().id().toLowerCase();
                PacketEvents.IDENTIFIER = "pe-" + id;
                PacketEvents.ENCODER_NAME = "pe-encoder-" + id;
                PacketEvents.DECODER_NAME = "pe-decoder-" + id;
                PacketEvents.CONNECTION_HANDLER_NAME = "pe-connection-handler-" + id;
                PacketEvents.SERVER_CHANNEL_HANDLER_NAME = "pe-connection-initializer-" + id;
                PacketEvents.TIMEOUT_HANDLER_NAME = "pe-timeout-handler-" + id;
                try {
                    SpongeReflectionUtil.init();
                    CustomPipelineUtil.init();
                    WrappedBlockState.ensureLoad();
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
                if (!PacketType.isPrepared()) {
                    PacketType.prepare();
                }
                boolean bl = this.lateBind = !this.injector.isServerBound();
                if (!this.lateBind) {
                    this.injector.inject();
                }
                this.loaded = true;
                this.getEventManager().registerListener(new InternalSpongePacketListener());
            }

            @Override
            public boolean isLoaded() {
                return this.loaded;
            }

            @Override
            public void init() {
                this.load();
                if (this.initialized) {
                    return;
                }
                Sponge.eventManager().registerListeners(plugin, (Object)new InternalSpongeListener());
                if (this.lateBind) {
                    Runnable lateBindTask = () -> {
                        if (this.injector.isServerBound()) {
                            this.injector.inject();
                        }
                    };
                    Sponge.server().scheduler().submit(Task.builder().plugin(plugin).execute(lateBindTask).build());
                }
                if (!"true".equalsIgnoreCase(System.getenv("PE_IGNORE_INCOMPATIBILITY"))) {
                    ViaVersionUtil.checkIfViaIsPresent();
                }
                this.initialized = true;
            }

            @Override
            public boolean isInitialized() {
                return this.initialized;
            }

            @Override
            public void terminate() {
                if (this.initialized) {
                    this.injector.uninject();
                    for (User user : this.protocolManager.getUsers()) {
                        ServerConnectionInitializer.destroyHandlers(user.getChannel());
                    }
                    this.getEventManager().unregisterAllListeners();
                    this.initialized = false;
                    this.terminated = true;
                }
            }

            @Override
            public boolean isTerminated() {
                return this.terminated;
            }

            @Override
            public PluginContainer getPlugin() {
                return plugin;
            }

            @Override
            public ProtocolManager getProtocolManager() {
                return this.protocolManager;
            }

            @Override
            public ServerManager getServerManager() {
                return this.serverManager;
            }

            @Override
            public PlayerManager getPlayerManager() {
                return this.playerManager;
            }

            @Override
            public PacketEventsSettings getSettings() {
                return this.settings;
            }

            @Override
            public NettyManager getNettyManager() {
                return this.nettyManager;
            }

            @Override
            public ChannelInjector getInjector() {
                return this.injector;
            }

            @Override
            public LogManager getLogManager() {
                return this.logManager;
            }
        };
    }
}

