/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.impl.sponge.injector.handlers;

import forcepack.libs.pe.api.PacketEvents;
import forcepack.libs.pe.api.event.PacketSendEvent;
import forcepack.libs.pe.api.exception.CancelPacketException;
import forcepack.libs.pe.api.exception.InvalidDisconnectPacketSend;
import forcepack.libs.pe.api.exception.PacketProcessException;
import forcepack.libs.pe.api.netty.buffer.ByteBufHelper;
import forcepack.libs.pe.api.protocol.ConnectionState;
import forcepack.libs.pe.api.protocol.player.User;
import forcepack.libs.pe.api.util.ExceptionUtil;
import forcepack.libs.pe.api.util.PacketEventsImplHelper;
import forcepack.libs.pe.impl.sponge.injector.connection.ServerConnectionInitializer;
import forcepack.libs.pe.impl.sponge.injector.handlers.PacketEventsDecoder;
import forcepack.libs.pe.impl.sponge.util.viaversion.CustomPipelineUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Sponge;

public class PacketEventsEncoder
extends MessageToMessageEncoder<ByteBuf> {
    public User user;
    public UUID player;
    private boolean handledCompression;
    private ChannelPromise promise;

    public PacketEventsEncoder(User user) {
        this.user = user;
    }

    public PacketEventsEncoder(ChannelHandler encoder) {
        this.user = ((PacketEventsEncoder)encoder).user;
        this.player = ((PacketEventsEncoder)encoder).player;
        this.handledCompression = ((PacketEventsEncoder)encoder).handledCompression;
        this.promise = ((PacketEventsEncoder)encoder).promise;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> list) throws Exception {
        boolean needsRecompression = !this.handledCompression && this.handleCompression(ctx, byteBuf);
        this.handleClientBoundPacket(ctx.channel(), this.user, this.player, byteBuf, this.promise);
        if (needsRecompression) {
            this.compress(ctx, byteBuf);
        }
        if (!ByteBufHelper.isReadable(byteBuf)) {
            throw CancelPacketException.INSTANCE;
        }
        list.add(byteBuf.retain());
    }

    @Nullable
    private PacketSendEvent handleClientBoundPacket(Channel channel, User user, UUID player, ByteBuf buffer, ChannelPromise promise) throws Exception {
        PacketSendEvent packetSendEvent = PacketEventsImplHelper.handleClientBoundPacket(channel, user, player == null ? null : Sponge.server().player(player).orElse(null), buffer, true);
        if (packetSendEvent != null && packetSendEvent.hasTasksAfterSend()) {
            promise.addListener(p -> {
                for (Runnable task : packetSendEvent.getTasksAfterSend()) {
                    task.run();
                }
            });
        }
        return packetSendEvent;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ChannelPromise oldPromise;
        ChannelPromise channelPromise = oldPromise = this.promise != null && !this.promise.isSuccess() ? this.promise : null;
        if (promise.isVoid()) {
            promise = ctx.newPromise();
        }
        promise.addListener(p -> {
            this.promise = oldPromise;
        });
        this.promise = promise;
        super.write(ctx, msg, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ExceptionUtil.isException(cause, CancelPacketException.class)) {
            return;
        }
        if (ExceptionUtil.isException(cause, InvalidDisconnectPacketSend.class)) {
            return;
        }
        boolean didWeCauseThis = ExceptionUtil.isException(cause, PacketProcessException.class);
        if (didWeCauseThis && this.user != null && this.user.getEncoderState() != ConnectionState.HANDSHAKING) {
            cause.printStackTrace();
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(ChannelHandlerContext ctx, ByteBuf input) throws InvocationTargetException {
        ChannelHandler compressor = ctx.pipeline().get("compress");
        ByteBuf temp = ctx.alloc().buffer();
        try {
            if (compressor != null) {
                CustomPipelineUtil.callEncode(compressor, ctx, input, temp);
            }
        }
        finally {
            input.clear().writeBytes(temp);
            temp.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompress(ChannelHandlerContext ctx, ByteBuf input, ByteBuf output) throws InvocationTargetException {
        ChannelHandler decompressor = ctx.pipeline().get("decompress");
        if (decompressor != null) {
            ByteBuf temp = (ByteBuf)CustomPipelineUtil.callDecode(decompressor, ctx, input).get(0);
            try {
                output.clear().writeBytes(temp);
            }
            finally {
                temp.release();
            }
        }
    }

    private boolean handleCompression(ChannelHandlerContext ctx, ByteBuf buffer) throws InvocationTargetException {
        if (this.handledCompression) {
            return false;
        }
        int compressIndex = ctx.pipeline().names().indexOf("compress");
        if (compressIndex == -1) {
            return false;
        }
        this.handledCompression = true;
        int peEncoderIndex = ctx.pipeline().names().indexOf(PacketEvents.ENCODER_NAME);
        if (peEncoderIndex == -1) {
            return false;
        }
        if (compressIndex > peEncoderIndex) {
            this.decompress(ctx, buffer, buffer);
            PacketEventsDecoder decoder = (PacketEventsDecoder)ctx.pipeline().get(PacketEvents.DECODER_NAME);
            ServerConnectionInitializer.relocateHandlers(ctx.channel(), decoder, this.user);
            return true;
        }
        return false;
    }
}

