/*
 * Decompiled with CFR 0.152.
 */
package forcepack.libs.pe.impl.sponge.manager;

import forcepack.libs.pe.api.PacketEvents;
import forcepack.libs.pe.api.event.PacketReceiveEvent;
import forcepack.libs.pe.api.manager.InternalPacketListener;
import forcepack.libs.pe.api.protocol.ConnectionState;
import forcepack.libs.pe.api.protocol.packettype.PacketType;
import forcepack.libs.pe.api.protocol.player.ClientVersion;
import forcepack.libs.pe.api.protocol.player.User;
import forcepack.libs.pe.api.util.LogManager;
import forcepack.libs.pe.api.wrapper.handshaking.client.WrapperHandshakingClientHandshake;
import forcepack.libs.pe.impl.sponge.util.viaversion.ViaVersionUtil;

public class InternalSpongePacketListener
extends InternalPacketListener {
    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Handshaking.Client.HANDSHAKE) {
            String feature;
            User user = event.getUser();
            WrapperHandshakingClientHandshake packet = new WrapperHandshakingClientHandshake(event);
            ClientVersion clientVersion = packet.getClientVersion();
            ConnectionState state = packet.getNextConnectionState();
            if (ViaVersionUtil.isAvailable()) {
                clientVersion = ClientVersion.getById(ViaVersionUtil.getProtocolVersion(user));
                feature = "ViaVersion";
            } else {
                feature = null;
            }
            LogManager logger = PacketEvents.getAPI().getLogManager();
            if (logger.isDebug()) {
                logger.debug("Processed handshake for " + event.getAddress() + ": " + state.name() + " / " + packet.getClientVersion().getReleaseName() + (feature != null ? " (using " + feature + ")" : ""));
            }
            user.setClientVersion(clientVersion);
            user.setConnectionState(state);
        } else {
            super.onPacketReceive(event);
        }
    }
}

