/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.api.utils;

import com.convallyria.forcepack.api.utils.Pair;
import com.convallyria.forcepack.api.verification.ResourcePackURLData;
import forcepack.libs.jakarta.xml.bind.DatatypeConverter;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;

public class HashingUtil {
    public static String toHexString(byte[] array) {
        return DatatypeConverter.printHexBinary(array);
    }

    public static byte[] toByteArray(String s) {
        return DatatypeConverter.parseHexBinary(s);
    }

    public static String getHashFromUrl(String url) throws Exception {
        return HashingUtil.getDataFromUrl(url).getFirst();
    }

    public static Pair<String, Integer> getDataFromUrl(String url) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        URLConnection urlConnection = new URL(url).openConnection();
        int sizeInMB = urlConnection.getContentLength() / 1024 / 1024;
        InputStream fis = urlConnection.getInputStream();
        int n = 0;
        byte[] buffer = new byte[8192];
        while (n != -1) {
            n = fis.read(buffer);
            if (n <= 0) continue;
            digest.update(buffer, 0, n);
        }
        fis.close();
        byte[] urlBytes = digest.digest();
        return Pair.of(HashingUtil.toHexString(urlBytes), sizeInMB);
    }

    public static ResourcePackURLData performPackCheck(String url, String configHash) throws Exception {
        Pair<String, Integer> data = HashingUtil.getDataFromUrl(url);
        return new ResourcePackURLData(data.getFirst(), configHash, data.getSecond());
    }
}

