/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.forcepack.paper;

import com.convallyria.forcepack.api.ForcePackAPI;
import com.convallyria.forcepack.api.ForcePackPlatform;
import com.convallyria.forcepack.api.player.ForcePackPlayer;
import com.convallyria.forcepack.api.resourcepack.ResourcePack;
import com.convallyria.forcepack.api.resourcepack.ResourcePackVersion;
import com.convallyria.forcepack.api.schedule.PlatformScheduler;
import com.convallyria.forcepack.api.utils.ClientVersion;
import com.convallyria.forcepack.api.utils.GeyserUtil;
import com.convallyria.forcepack.api.utils.HashingUtil;
import com.convallyria.forcepack.api.verification.ResourcePackURLData;
import com.convallyria.forcepack.folia.schedule.FoliaScheduler;
import com.convallyria.forcepack.paper.command.Commands;
import com.convallyria.forcepack.paper.integration.ItemsAdderIntegration;
import com.convallyria.forcepack.paper.libs.adventure.adventure.platform.bukkit.BukkitAudiences;
import com.convallyria.forcepack.paper.libs.adventure.adventure.text.minimessage.MiniMessage;
import com.convallyria.forcepack.paper.libs.bstats.bukkit.Metrics;
import com.convallyria.forcepack.paper.libs.languagy.api.adventure.AdventurePlatform;
import com.convallyria.forcepack.paper.libs.languagy.api.language.Language;
import com.convallyria.forcepack.paper.libs.languagy.api.language.Translator;
import com.convallyria.forcepack.paper.listener.ExemptionListener;
import com.convallyria.forcepack.paper.listener.PacketListener;
import com.convallyria.forcepack.paper.listener.ResourcePackListener;
import com.convallyria.forcepack.paper.listener.VelocityMessageListener;
import com.convallyria.forcepack.paper.player.ForcePackPaperPlayer;
import com.convallyria.forcepack.paper.resourcepack.PaperResourcePack;
import com.convallyria.forcepack.paper.schedule.BukkitScheduler;
import com.convallyria.forcepack.paper.translation.Translations;
import com.convallyria.forcepack.paper.util.ProtocolUtil;
import com.convallyria.forcepack.webserver.ForcePackWebServer;
import com.convallyria.forcepack.webserver.downloader.WebServerDependencyDownloader;
import forcepack.libs.pe.api.PacketEvents;
import forcepack.libs.pe.impl.factory.spigot.SpigotPacketEventsBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ForcePackPaper
extends JavaPlugin
implements ForcePackPlatform {
    private Translator translator;
    private PlatformScheduler<?> scheduler;
    private final Map<ResourcePackVersion, Set<ResourcePack>> resourcePacks = new HashMap<ResourcePackVersion, Set<ResourcePack>>();
    public boolean velocityMode;
    private BukkitAudiences adventure;
    public final Set<UUID> temporaryExemptedPlayers = new HashSet<UUID>();
    private final Map<UUID, ForcePackPlayer> waiting = new HashMap<UUID, ForcePackPlayer>();
    private @Nullable ForcePackWebServer webServer;

    @Override
    public Set<ResourcePack> getResourcePacks() {
        return this.resourcePacks.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<ResourcePack> getPacksForVersion(Player player) {
        int protocolVersion = ProtocolUtil.getProtocolVersion(player);
        return this.getPacksForVersion(protocolVersion);
    }

    @Override
    public PlatformScheduler<?> getScheduler() {
        return this.scheduler;
    }

    @Override
    public boolean exemptNextResourcePackSend(UUID uuid) {
        return this.temporaryExemptedPlayers.add(uuid);
    }

    public void processWaitingResourcePack(Player player, UUID packId) {
        UUID playerId = player.getUniqueId();
        if (ProtocolUtil.getProtocolVersion(player) < 765) {
            this.removeFromWaiting(player);
            return;
        }
        ForcePackPlayer newPlayer = this.waiting.computeIfPresent(playerId, (a, forcePackPlayer) -> {
            Set<ResourcePack> packs = forcePackPlayer.getWaitingPacks();
            packs.removeIf(pack -> pack.getUUID().equals(packId));
            return forcePackPlayer;
        });
        if (newPlayer == null || newPlayer.getWaitingPacks().isEmpty()) {
            this.removeFromWaiting(player);
        }
    }

    public Optional<ForcePackPlayer> getForcePackPlayer(Player player) {
        return Optional.ofNullable(this.waiting.get(player.getUniqueId()));
    }

    public boolean isWaiting(Player player) {
        return this.waiting.containsKey(player.getUniqueId());
    }

    public boolean isWaitingFor(Player player, UUID packId) {
        if (!this.isWaiting(player)) {
            return false;
        }
        if (ProtocolUtil.getProtocolVersion(player) < 765) {
            return true;
        }
        Set<ResourcePack> waitingPacks = this.waiting.get(player.getUniqueId()).getWaitingPacks();
        return waitingPacks.stream().anyMatch(pack -> pack.getUUID().equals(packId));
    }

    public void removeFromWaiting(Player player) {
        this.waiting.remove(player.getUniqueId());
    }

    public void addToWaiting(UUID uuid, @NonNull Set<ResourcePack> packs) {
        this.waiting.compute(uuid, (a, existing) -> {
            ForcePackPlayer newPlayer = existing != null ? existing : new ForcePackPaperPlayer(Bukkit.getPlayer((UUID)uuid));
            newPlayer.getWaitingPacks().addAll(packs);
            return newPlayer;
        });
    }

    public Optional<ForcePackWebServer> getWebServer() {
        return Optional.ofNullable(this.webServer);
    }

    public void onEnable() {
        this.generateLang();
        this.createConfig();
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().getSettings().debug(this.debug()).preViaInjection(true).checkForUpdates(false);
        PacketEvents.getAPI().load();
        GeyserUtil.isGeyserInstalledHere = Bukkit.getPluginManager().getPlugin("Geyser-Spigot") != null;
        this.adventure = BukkitAudiences.create((Plugin)this);
        MiniMessage miniMessage = MiniMessage.miniMessage();
        this.velocityMode = this.getConfig().getBoolean("velocity-mode");
        this.scheduler = FoliaScheduler.RUNNING_FOLIA ? new FoliaScheduler(this) : new BukkitScheduler(this);
        this.registerListeners();
        this.registerCommands();
        this.translator = Translator.of((Plugin)this, "lang", Language.BRITISH_ENGLISH, this.debug(), AdventurePlatform.create(miniMessage, this.adventure));
        PacketEvents.getAPI().init();
        try {
            this.performLegacyCheck();
            this.checkForServerProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Runnable run = () -> {
            if (this.getConfig().getBoolean("web-server.enabled")) {
                try {
                    this.getLogger().info("Enabling web server...");
                    this.getLogger().info("Downloading required dependencies, this might take a while! Subsequent startups will be faster.");
                    WebServerDependencyDownloader.download(this, this.getDataFolder().toPath(), x$0 -> this.log((String)x$0, new Object[0]));
                    this.getLogger().info("Finished downloading required dependencies.");
                    String configIp = this.getConfig().getString("web-server.server-ip", "localhost");
                    String serverIp = !configIp.equals("localhost") ? configIp : (!Bukkit.getIp().isEmpty() ? Bukkit.getIp() : ForcePackWebServer.getIp());
                    this.webServer = new ForcePackWebServer(this.getDataFolder().toPath(), serverIp, this.getConfig().getInt("web-server.port", 8080));
                    this.getLogger().info("Started web server.");
                }
                catch (IOException e) {
                    this.getLogger().severe("Error starting web server: " + e.getMessage());
                    this.getLogger().severe("It is highly likely you need to open a port or change it in the config. Please see the config for further information.");
                    return;
                }
            }
            this.reload();
            new Metrics(this, 13677);
            this.getLogger().info("Completed loading resource packs.");
        };
        if (this.getConfig().getBoolean("await-items-adder-host") && Bukkit.getPluginManager().getPlugin("ItemsAdder") != null) {
            new ItemsAdderIntegration(this, run);
            return;
        }
        if (this.getConfig().getBoolean("load-last")) {
            this.scheduler.registerInitTask(run);
        } else {
            run.run();
        }
        if (GeyserUtil.isGeyserInstalledHere && !this.getConfig().getBoolean("Server.geyser")) {
            this.getLogger().warning("Geyser is installed but Geyser support is not enabled.");
        } else if (!GeyserUtil.isGeyserInstalledHere && this.getConfig().getBoolean("Server.geyser")) {
            this.getLogger().warning("Geyser is not installed but Geyser support is enabled.");
        }
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
        if (this.webServer != null) {
            this.webServer.shutdown();
        }
        if (this.translator != null) {
            this.translator.close();
        }
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
    }

    public void reload() {
        if (this.velocityMode) {
            return;
        }
        this.resourcePacks.clear();
        this.getWebServer().ifPresent(ForcePackWebServer::clearHostedPacks);
        ConfigurationSection packs = this.getConfig().getConfigurationSection("Server.packs");
        boolean success = true;
        for (String versionId : packs.getKeys(false)) {
            ResourcePackVersion version = this.getVersionFromId(versionId);
            ConfigurationSection packSection = packs.getConfigurationSection(versionId);
            List<String> urls = packSection.isSet("urls") ? packSection.getStringList("urls") : List.of(packSection.getString("url", ""));
            List<String> hashes = packSection.isSet("hashes") ? packSection.getStringList("hashes") : List.of(packSection.getString("hash", ""));
            boolean generateHash = packSection.getBoolean("generate-hash");
            if (!generateHash && urls.size() != hashes.size()) {
                this.getLogger().severe("There are not the same amount of URLs and hashes! Please provide a hash for every resource pack URL!");
            }
            for (int i = 0; i < urls.size(); ++i) {
                String url = urls.get(i);
                String hash = i >= hashes.size() ? null : hashes.get(i);
                success = success && this.checkPack(version, url, generateHash, hash);
            }
        }
        if (!success) {
            this.getLogger().severe("Unable to load all resource packs correctly.");
        }
    }

    private boolean checkPack(@Nullable ResourcePackVersion version, String url, boolean generateHash, @Nullable String hash) {
        if (((String)url).startsWith("forcepack://")) {
            File generatedFilePath = new File(String.valueOf(this.getDataFolder()) + File.separator + ((String)url).replace("forcepack://", ""));
            this.log("Using local resource pack host for " + (String)url + " (" + String.valueOf(generatedFilePath) + ")", new Object[0]);
            if (this.webServer == null) {
                this.getLogger().severe("Unable to locally host resource pack '" + (String)url + "' because the web server is not active!");
                return false;
            }
            this.webServer.addHostedPack(generatedFilePath);
            url = this.webServer.getHostedEndpoint((String)url);
        }
        this.checkForRehost((String)url);
        this.checkValidEnding((String)url);
        AtomicInteger sizeMB = new AtomicInteger();
        ResourcePackURLData data = null;
        if (generateHash) {
            this.getLogger().info("Auto-generating resource pack hash.");
            try {
                data = HashingUtil.performPackCheck((String)url, hash);
                sizeMB.set(data.getSize());
                hash = data.getUrlHash();
                this.getLogger().info("Size of resource pack: " + sizeMB.get() + " MB");
                this.getLogger().info("Auto-generated resource pack hash: " + hash);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Unable to auto-generate resource pack hash, reverting to config setting", e);
            }
        }
        if (this.getConfig().getBoolean("enable-mc-164316-fix")) {
            url = (String)url + "#" + hash;
        }
        if (this.getConfig().getBoolean("Server.verify")) {
            try {
                Consumer<Integer> consumer = size -> {
                    this.getLogger().info("Performing version size check...");
                    for (ClientVersion clientVersion : ClientVersion.values()) {
                        String sizeStr = clientVersion.getDisplay() + " (" + clientVersion.getMaxSizeMB() + " MB): ";
                        if (clientVersion.getMaxSizeMB() < size) {
                            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + sizeStr + "Unsupported.");
                            continue;
                        }
                        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + sizeStr + "Supported.");
                    }
                    sizeMB.set((int)size);
                };
                if (data == null) {
                    data = HashingUtil.performPackCheck((String)url, hash);
                }
                consumer.accept(data.getSize());
                if (hash == null || !hash.equalsIgnoreCase(data.getUrlHash())) {
                    this.getLogger().severe("-----------------------------------------------");
                    this.getLogger().severe("Your hash does not match the URL file provided!");
                    this.getLogger().severe("The URL hash returned: " + data.getUrlHash());
                    this.getLogger().severe("Your config hash returned: " + data.getConfigHash());
                    this.getLogger().severe("Please provide a correct SHA-1 hash!");
                    this.getLogger().severe("-----------------------------------------------");
                } else {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "Hash verification complete.");
                }
            }
            catch (Exception e) {
                this.getLogger().severe("Please provide a correct SHA-1 hash/url!");
                e.printStackTrace();
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return false;
            }
        }
        Object finalUrl = url;
        String finalHash = hash;
        this.resourcePacks.compute(version, (arg_0, arg_1) -> this.lambda$checkPack$7((String)finalUrl, finalHash, sizeMB, version, arg_0, arg_1));
        return true;
    }

    private void registerListeners() {
        PluginManager pm = Bukkit.getPluginManager();
        if (this.velocityMode) {
            this.getLogger().info("Enabled velocity listener");
            this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "forcepack:status", (PluginMessageListener)new VelocityMessageListener(this));
        }
        pm.registerEvents((Listener)new ResourcePackListener(this), (Plugin)this);
        pm.registerEvents((Listener)new ExemptionListener(this), (Plugin)this);
        PacketEvents.getAPI().getEventManager().registerListeners(new PacketListener(this));
    }

    private void registerCommands() {
        new Commands(this);
    }

    private void generateLang() {
        Translations.generateLang(this);
    }

    private void createConfig() {
        this.saveDefaultConfig();
    }

    private void checkValidEnding(String url) {
        if (!this.isValidEnding(url)) {
            this.getLogger().severe("Your URL has an invalid or unknown format. URLs must have no redirects and use the .zip extension. If you are using Dropbox, change dl=0 to dl=1.");
            this.getLogger().severe("ForcePack will still load in the event this check is incorrect. Please make an issue or pull request if this is so.");
        }
    }

    private void checkForRehost(String url) {
        if (this.isDefaultHost(url)) {
            this.getLogger().warning(String.format("[%s] You are using a default resource pack provided by the plugin. ", url) + " It's highly recommended you re-host this pack using the webserver or on a CDN such as https://mc-packs.net for faster load times. Leaving this as default potentially sends a lot of requests to my personal web server, which isn't ideal!");
            this.getLogger().warning("ForcePack will still load and function like normally.");
        }
        this.getBlacklistedSite(url).ifPresent(blacklistedSite -> this.getLogger().severe("Invalid resource pack site used! '" + blacklistedSite + "' cannot be used for hosting resource packs!"));
    }

    private void performLegacyCheck() throws IOException {
        Map<String, PlayerResourcePackStatusEvent.Status> sections = Map.of("Server.Actions.On_Accept", PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED, "Server.Actions.On_Deny", PlayerResourcePackStatusEvent.Status.DECLINED, "Server.Actions.On_Fail", PlayerResourcePackStatusEvent.Status.FAILED_DOWNLOAD);
        boolean kick = this.getConfig().getBoolean("Server.kick");
        for (String sectionName : sections.keySet()) {
            PlayerResourcePackStatusEvent.Status status = sections.get(sectionName);
            ConfigurationSection section = this.getConfig().getConfigurationSection(sectionName);
            if (section == null) continue;
            this.getLogger().warning("Detected legacy '" + sectionName + "' action, converting your config now (consider regenerating config for comments and new settings!)...");
            this.getConfig().set("Server.Actions." + status.name() + ".Commands", (Object)section.getStringList("Command"));
            this.getConfig().set("Server.Actions." + status.name() + ".kick", (Object)(status != PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED && kick ? 1 : 0));
            this.getConfig().set(sectionName, null);
            this.getConfig().set("Server.kick", null);
            this.getConfig().save(new File(String.valueOf(this.getDataFolder()) + File.separator + "config.yml"));
        }
        ConfigurationSection oldPackSection = this.getConfig().getConfigurationSection("Server.ResourcePack");
        if (oldPackSection != null) {
            this.getLogger().warning("Detected legacy resource pack section, converting your config now (consider regenerating config for comments and new settings!)...");
            String oldUrl = oldPackSection.getString("url");
            boolean oldGenerateHash = oldPackSection.getBoolean("generate-hash");
            String oldHash = oldPackSection.getString("hash");
            this.getConfig().set("Server.packs.all.url", (Object)oldUrl);
            this.getConfig().set("Server.packs.all.generate-hash", (Object)oldGenerateHash);
            this.getConfig().set("Server.packs.all.hash", (Object)oldHash);
            this.getConfig().set("Server.ResourcePack", null);
            this.getConfig().save(new File(String.valueOf(this.getDataFolder()) + File.separator + "config.yml"));
        }
    }

    private void checkForServerProperties() throws IOException {
        Properties properties = new Properties();
        try (FileReader reader = new FileReader("./server.properties");){
            properties.load(reader);
            String packUrl = properties.getProperty("resource-pack");
            if (packUrl != null && !packUrl.isEmpty()) {
                this.getLogger().severe("You have a resource pack set in server.properties!");
                this.getLogger().severe("This will cause ForcePack to not function correctly. You MUST remove the resource pack URL from server.properties!");
            }
        }
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public boolean debug() {
        return this.getConfig().getBoolean("Server.debug");
    }

    @Override
    public void log(String info, Object ... format) {
        if (this.debug()) {
            this.getLogger().info(String.format(info, format));
        }
    }

    public static ForcePackAPI getAPI() {
        return ForcePackPaper.getInstance();
    }

    public static ForcePackPaper getInstance() {
        return (ForcePackPaper)ForcePackPaper.getPlugin(ForcePackPaper.class);
    }

    private /* synthetic */ Set lambda$checkPack$7(String finalUrl, String finalHash, AtomicInteger sizeMB, ResourcePackVersion version, ResourcePackVersion u, Set existingPacks) {
        Set packs = existingPacks == null ? new HashSet() : existingPacks;
        PaperResourcePack pack = new PaperResourcePack(this, finalUrl, finalHash, sizeMB.get(), version);
        packs.add(pack);
        this.getLogger().info("Generated resource pack (" + pack.getURL() + ") for version " + String.valueOf(version == null ? "all" : version) + " with id " + String.valueOf(pack.getUUID()));
        return packs;
    }
}

